(function()
{
    var moduleName = 'cla.badges_service';

	// Manual singleton as the .service() appears to return multiple instances across Angular apps
	var instance = null;
	if (instance === null)
		instance = new BadgesService();

    angular.module(moduleName)
        .service('claBadgesService', ['$http', 'growl.service', 'badgePreloadFactory', 'claEventQueue', function($http, growlService, preload, eventQueue)
		{
			instance.setHttp($http);
			instance.setGrowlService(growlService);
			instance.setEventQueue(eventQueue);
			instance.init({
                badge_list: preload.badge_list,
                perms: preload.perms,
                badge_id: preload.badge_id
			});
			return instance;
		}]);

    function BadgesService()
    {
        var service = this;
        service.baseUrl = '/api/badges';

        service.filterTerm = '';
        service.sort = 'title';
        service.sort_dir = 'asc';
        service.badge_id = null;
        service.badges = [];
        service.badgesMaster = [];
        service.perms = {
            canManage: false,
            canAssignAny: false,
            canAssignSubordinates: false,
            canAssign: false,
            subordinates: []
        };
        service.isActive = false;

        service.updateCallbacks = [];
        service.assignCallbacks = [];

        service.fetchLatest = function()
        {
            service.isActive = true;
            service.$http.get(service.baseUrl + '/badges?include_assignees=true&sort=' + service.sort + '&sort_dir=' + service.sort_dir).then(function(data){
                service.isActive = false;
                service.init({
                    badge_list: data.data,
                    perms: service.perms
                });
                for (var i = 0; i < service.updateCallbacks.length; i++)
                {
                    service.updateCallbacks[i]();
                }
            }, function(data){
                service.isActive = false;
                var error = data.data;
                var title = lmsg('badges.manage.ajax.unknown_error');
                if (typeof data.data === 'object')
                {
                    if (data.data.detail !== undefined)
                    {
                        error = data.data.detail;
                        title = data.data.title;
                    } else
                    {
                        error = data.data.message;
                    }
                }
                service.growlService.showError(title, error);
            });
        };

        service.registerUpdateCallback = function(callback)
        {
            service.updateCallbacks.push(callback);
        };

        service.registerAssignCallback = function(callback)
        {
            service.assignCallbacks.push(callback);
        };

        service.init = function(data)
        {
            var badges = data.badge_list;
            var perms = data.perms;

            service.badgesMaster.length = 0;
            for (var i = 0; i < badges.length; i++)
            {
                service.badgesMaster.push(badges[i]);
            }

            service.applyFilter();

            service.perms.canManage = perms.canManage;
            service.perms.canAssignAny = perms.canAssignAny;
            service.perms.canAssignSubordinates = perms.canAssignSubordinates;
            service.perms.canAssign = perms.canAssignAny || perms.canAssignSubordinates;
            service.perms.subordinates = perms.subordinates;

            if (data.badge_id !== undefined)
            {
            	service.badge_id = data.badge_id;
            }
        };

        service.getBadges = function()
        {
            return service.badges;
        };

        service.getBadgesMaster = function()
        {
            return service.badgesMaster;
        };

        service.assignBadges = function(userIds, badgeIds, message, callback, failCallback)
        {
            service.isActive = true;
			service.$http.post(service.baseUrl + '/badges/assign', {
                "badge_ids": badgeIds,
                "user_ids": userIds,
                "message": message
            }).then(function(data){
                service.isActive = false;
				service. growlService.showSuccess(lmsg('badges.success.badge_assigned'));

                service.eventQueue.send('badges.update_data');
                if (typeof callback === 'function')
                    callback();
            }, function(data){
                service.isActive = false;
                var error = data.data;
                var title = lmsg('badges.manage.ajax.unknown_error');
                if (typeof data.data === 'object')
                {
                    if (data.data.detail !== undefined)
                    {
                        error = data.data.detail;
                        title = data.data.title;
                    } else
                    {
                        error = data.data.message;
                    }
                }
                if (typeof failCallback === 'function')
                    failCallback();
                service.growlService.showError(title, error);
            });
        };

	    service.unassignBadges = function(userIds, badgeId, message, callback, failCallback)
	    {
            service.isActive = true;
		    service.$http.post(service.baseUrl + '/badges/' + badgeId + '/unassign', {
			    "user_ids": userIds,
			    "message": message
		    }).then(function(data){
                service.isActive = false;
			    service. growlService.showSuccess(lmsg('badges.success.badge_unassigned'));

                service.eventQueue.send('badges.update_data');
                if (typeof callback === 'function')
                    callback();
		    }, function(data){
                service.isActive = false;
                var error = data.data;
                var title = lmsg('badges.manage.ajax.unknown_error');
                if (typeof data.data === 'object')
                {
                    if (data.data.detail !== undefined)
                    {
                        error = data.data.detail;
                        title = data.data.title;
                    } else
                    {
                        error = data.data.message;
                    }
                }
                if (typeof failCallback === 'function')
                    failCallback();
                service.growlService.showError(title, error);
		    });
	    };

        service.saveBadge = function(id, title, description, imageId, status, colour, callback, failCallback, successMessage)
        {
            var data = {};
            if (id === 0)
            {
                data = {
                    title: title,
                    description: description,
                    image_id: imageId,
                    status: 'live',
                    background_colour: colour
                };

                service.isActive = true;
                service.$http.post(service.baseUrl + '/badges', data).then(function(data){
                    service.isActive = false;
                    var message = successMessage === undefined ? data.data.message : successMessage;
                    service.growlService.showSuccess(message);
                    if (typeof callback === 'function')
                        callback();
                    service.eventQueue.send('badges.update_data');
                }, function(data){
                    service.isActive = false;
                    var error = data.data;
                    var title = lmsg('badges.manage.ajax.unknown_error');
                    if (typeof data.data === 'object')
                    {
                        if (data.data.detail !== undefined)
                        {
                            error = data.data.detail;
                            title = data.data.title;
                        } else
                        {
                            error = data.data.message;
                        }
                    }
                    if (typeof failCallback === 'function')
                        failCallback();
                    service.growlService.showError(title, error);
                });
            } else
            {
                data = {
                    title: title,
                    description: description,
                    image_id: imageId,
                    status: status,
                    background_colour: colour
                };

                service.isActive = true;
                service.$http.put(service.baseUrl + '/badges/' + id, data).then(function(data){
                    service.isActive = false;
                    var message = successMessage === undefined ? data.data.message : successMessage;
                    service.growlService.showSuccess(message);
                    if (typeof callback === 'function')
                        callback();
                    service.eventQueue.send('badges.update_data');
                }, function(data){
                    service.isActive = false;
                    var error = data.data;
                    var title = lmsg('badges.manage.ajax.unknown_error');
                    if (typeof data.data === 'object')
                    {
                        if (data.data.detail !== undefined)
                        {
                            error = data.data.detail;
                            title = data.data.title;
                        } else
                        {
                            error = data.data.message;
                        }
                    }
                    if (typeof failCallback === 'function')
                        failCallback();
                    service.growlService.showError(title, error);
                });
            }
        };

        service.getPerms = function()
        {
            return service.perms;
        };

        service.applyFilter = function()
        {
            angular.element('.js-bob').removeClass('badgebob');

            // Don't mention the animals
            var match = 'badge';

            service.badges.length = 0;
            for (var i = 0; i < service.badgesMaster.length; i++)
            {
                service.shouldBob = false;
                // Restore the image if they were temporarily modified locally for any reason
                if (service.badgesMaster[i].image_original !== undefined)
                {
                    service.badgesMaster[i].image = service.badgesMaster[i].image_original;
                    service.badgesMaster[i].image_original = undefined;
                }
                var term = service.filterTerm.toLowerCase();
                if (service.filterTerm === match+'rs'+match+'rs'+match+'rs')
                {
                    service.shouldBob = true;
                    var badge = service.badgesMaster[i];
                    badge.image_original = badge.image;
                    badge.image = '/intranet/badges/images/'+match+'r.svg';

                    service.badges.push(badge);
                    setTimeout(function(){
                        angular.element('.js-bob').addClass('badgebob');
                    }, 100);
                } else if ((service.filterTerm === '') ||
                    (service.badgesMaster[i].title.toLowerCase().includes(term)) ||
                    (service.badgesMaster[i].description.toLowerCase().includes(term)))
                {
                    var badge = service.badgesMaster[i];
                    service.badges.push(badge);
                }
            }
        };

        service.setFilterTerm = function(term)
        {
            service.filterTerm = term;
            service.applyFilter();

            for (var i = 0; i < service.updateCallbacks.length; i++)
            {
                service.updateCallbacks[i]();
            }
        };

		service.getFilterTerm = function()
		{
			return service.filterTerm;
		};

        //this method is used by the badge detail page
        service.getBadgeId = function()
        {
        	return service.badge_id;
        };

        service.setSort = function(sort)
        {
            service.sort = sort;
        };

        service.setSortDir = function(sort_dir)
        {
            service.sort_dir = sort_dir;
        };

        service.doSort = function()
        {
            service.fetchLatest();
        };

		// Angular can't inject dependencies into a singleton so we have to pass this in manually.
		// Only the first one is saved to avoid any state-change issues being overwritten mid-request.
		service.$http = null;
		service.setHttp = function($http)
		{
			if (service.$http === null)
				service.$http = $http;
		};

		service.growlService = null;
		service.setGrowlService = function(growlService)
		{
			if (service.growlService === null)
				service.growlService = growlService;
		};

        service.eventQueue = null;
        service.setEventQueue = function(eventQueue)
        {
            if (service.eventQueue === null)
            {
                service.eventQueue = eventQueue;

                // Register the update handler
                service.eventQueue.onEvent('badges.update_data', function(){
                    service.fetchLatest()
                });
            }
        };

        service.getAssigneesForBadge = function(badgeId)
        {
            for (var badgeLoop = 0; badgeLoop < service.badges.length; badgeLoop++)
            {
                if (service.badges[badgeLoop].id === badgeId)
                {
                    var assignees = service.badges[badgeLoop].assignees;
                    if (assignees === undefined)
                        assignees = [];

                    return assignees;
                }
            }

            return [];
        };
    }
}());
