define(['cla_angular', '../../html/directives/badges_order.html'], function (angular, template)
{
	var moduleName = 'cla.badges.badges_order';
	var module;
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, ['cla.badges.options.service', 'ui.sortable']);
	}

	module.directive('claBadgesOrder', ['$timeout', 'badgesOptionsService', badgesOrder]);

	function badgesOrder($timeout, service)
	{
		var controller = function()
		{
			var ctrl = this;

			this.$onInit = function() {
				ctrl.dragOptions = {
					orderChanged: function () {
						ctrl.syncOrder();
					},
					containment: '#drag-list-' + ctrl.id,
					appendTo: '#drag-list-' + ctrl.id,
					containerPositioning: 'relative'
				};

				for (var i = 0; i < ctrl.ngModel.length; i++)
				{
					service.addBadgeOrder(ctrl.ngModel[i]);
				}
			};

			ctrl.order = service.badges_order;
			ctrl.order.length = 0;
			ctrl.dragOptions = {};
			ctrl.areAnyHidden = false;

			ctrl.syncOrder = function()
			{
				ctrl.ngModel.length = 0;
				for (var i = 0; i < ctrl.order.length; i++)
					ctrl.ngModel.push(ctrl.order[i]);
			};

			//callback function to service
			service.register_callback(ctrl.syncOrder);

			$timeout(function () {
				service.compareBadgeDataAndOrder();
			}, 0);
		};

		return {
			controller: controller,
			bindToController: true,
			controllerAs: 'ctrl',
			restrict: 'E',
			require: '^ngModel',
			templateUrl: template,
			scope: {
				ngModel: '=',
				id: '@'
			}
		};
	}
});
