define(['cla_angular', '../../../html/directives/core/user_picker_multi.html', 'user_picker', 'cla_select2'], function (angular, template) {
	var moduleName = 'cla.core.user_picker_multi';
    var module;
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, []);
	}

	module
        .directive('claUserPickerMulti', userPickerMulti);

	userPickerMulti.$inject = ['$timeout'];
	function userPickerMulti($timeout) {
		return {
			link: link,
			restrict: 'E',
			require: '^ngModel',
			templateUrl: template,
			scope: {
				ngModel: '=',
				control: '=',
				userIds: '@'
			}
		};

		function link(scope, iElement, iAttrs, ctrl) {
			scope.id = iAttrs.selectId + '-inner';
			scope.user_name = iAttrs.userName;

			// Use a directive property for localized value to avoid forcing a dependency on the lmsg directive
			scope.localized_browse = lmsg('common.user_picker.browse');

			iElement.hide();

			// Angular won't have populated the control/browse ids yet so wait until the current event is finished
			$timeout(function(id, text, element) {
				scope.initSelect2(id, text);
				element.show();
			}, 0, true, scope.id, lmsg('common.picker.select_user'), iElement);

			$('#' + scope.id).append($('<option>').attr('value', '' + ctrl.$modelValue).attr('selected', 'selected').text(scope.user_name));
			UserPicker_InitSelect2(scope.id, '', lmsg('common.picker.select_user'), scope.userIds);

			ctrl.$viewChangeListeners.push(function () {
				scope.$eval(iAttrs.ngChange);
			});

			scope.initSelect2 = function (id, text) {
				var select = $('#' + id);
				select.find('option').remove();

				UserPicker_InitSelect2(scope.id, '', text, scope.userIds);
			};

			scope.change = function (event) {
				ctrl.$setViewValue(scope.ngModel);
				ctrl.$render();

				$timeout(function(users) {
					ctrl.$setViewValue(users);
					ctrl.$render();
				}, 0, true, scope.ngModel);
			};

			scope.browse = function (event) {
				event.preventDefault();
				var recwnd = window.open('/intranet/common/user_picker_popup.php?input_dom_id=' + scope.id + '&users_ids=' + scope.userIds + '&multi=1', 'user_picker_wnd', 'width=800,height=450,scrollbars=yes,resizable=yes,hotkeys=no,maximize=no');
				recwnd.focus();
			};

			scope.internalControl = scope.control || {};
			scope.internalControl.reset = function()
			{
				// Rebind the model. This shouldn't be needed but it never gets updated once reset otherwise
				ctrl.$setViewValue(scope.ngModel);

				scope.initSelect2(scope.id, lmsg('common.picker.select_user'), true);
			};
		}
	}

	// Initialize the "select2" element for the multi-user picker
	function UserPicker_InitSelect2(element_id, query_params, placeholder, user_ids) {
		var el = angular.element('#' + element_id);
		var page_size = 50;
		var r = el.select2({
			placeholder: placeholder,
			minimumInputLength: 1,
			ajax: {
				url: "/intranet/common/user_picker_popup.php?json=1&multi=1"+query_params,
				dataType: 'json',
				data: function (params) {
					return {
						keywords: params.term, // search term
						page: params.page,
						page_size: page_size,
						st: (params.page-1) * page_size,
						users_ids: user_ids
					};
				},
				processResults: function (data, params) {
					params.page = params.page || 1;

					return {
						results: data.data,
						pagination: {
							more: ((params.page) * page_size) < data.total
						}
					};
				}
			}
		});
	}
});
