(function()
{
	var moduleName = 'cla.badges_detail';
	var template = require('../../../html/directives/detail/badge_assigned.html');

	angular.module(moduleName)
		.directive('badgeAssigned', badgeAssigned);

	badgeAssigned.$inject = ['claSingleBadgeService'];
	function badgeAssigned(service)
	{
		return {
			restrict: 'E',
			templateUrl: template,
			scope: {},
			controllerAs: 'ctrl',
			bindToController: true,
			controller: controller
		};

		function controller()
		{
			var ctrl = this;

            this.$onInit = function() {
                ctrl.badge_id = 0;
                ctrl.assigned = [];
                ctrl.assigned_paginated = [];
                ctrl.rows_per_page = 10;
                ctrl.total_rows = 0;
                ctrl.original_total_rows = 0;
                ctrl.filter = '';
                ctrl.pagination = {
                    current: 1
                };
                ctrl.init(service.getBadge(), 0);
                ctrl.perms = service.getPerms();

                service.registerUpdateCallback(function () {
                    ctrl.init(service.getBadge(), 0);
                    ctrl.pagination.current = 1;
                });
            };

			ctrl.init = function (badge, page) {
			    ctrl.badge_id = badge.id;
				ctrl.is_earned = false;
				ctrl.assigned.length = 0;
				ctrl.assigned_paginated.length = 0;
				ctrl.total_rows = 0;
                ctrl.original_total_rows = 0;

                if (badge.assigned instanceof Array) {
                    ctrl.original_total_rows = badge.assigned.length;
                    for (var c = 0; c < badge.assigned.length; c++) {
                        var matched = false;
                        if (ctrl.filter === '')
                        {
                            matched = true;
                        } else
                        {
                            if (badge.assigned[c].assigned_to.name.toLowerCase().indexOf(ctrl.filter.toLowerCase()) >= 0)
                                matched = true;
                        }

                        if (matched)
                            ctrl.assigned.push(badge.assigned[c]);
                    }
                }
                ctrl.total_rows = ctrl.assigned.length;

				// Badge assignments should be shown newest-first
				ctrl.assigned.sort(function(a, b){
				    if (a.assigned_date.date === b.assigned_date.date)
				        return 0;

				    return (a.assigned_date.date > b.assigned_date.date) ? 1 : -1;
                });

				ctrl.assigned_paginated = ctrl.assigned.slice(page * ctrl.rows_per_page, (page + 1) * ctrl.rows_per_page);
			};

			ctrl.unassign = function (user_id) {
				service.unassignBadges([user_id], ctrl.badge_id, '');
			};

			ctrl.pageChanged = function(page)
			{
				ctrl.init(service.getBadge(), page - 1);
			};

			ctrl.filterChanged = function()
            {
                ctrl.init(service.getBadge(), 0);
            };

			ctrl.canUnassign = function(user)
            {
                if (ctrl.perms.canAssignAny)
                    return true;

                if (ctrl.perms.canAssignSubordinates)
                {
                    return ctrl.perms.subordinates.indexOf(user.assigned_to.id) !== -1;
                }

                return false;
            };

            // ToDo: Remove these lines when a Claro >=8.10 compatible branch of this module is available
            if (angular.version.major === 1 && angular.version.minor < 5) {
                this.$onInit();
            }
		}
	}
}());
