(function()
{
	var moduleName = 'cla.badges_detail';
	var template = require('../../../html/directives/detail/badge_not_assigned.html');

	angular.module(moduleName)
		.directive('badgeNotAssigned', badgeNotAssigned);

	badgeNotAssigned.$inject = ['claSingleBadgeService'];
	function badgeNotAssigned(service)
	{
		return {
			restrict: 'E',
			templateUrl: template,
			scope: {},
			controllerAs: 'ctrl',
			bindToController: true,
			controller: controller
		};

		function controller()
		{
			var ctrl = this;
            this.$onInit = function() {
                ctrl.assigned = [];

                service.registerUpdateCallback(function () {
                    ctrl.init(service.getBadge());
                });

                ctrl.init(service.getBadge());
            };

			ctrl.init = function (badge) {
				ctrl.badge_id = badge.id;
				ctrl.is_earned = false;
				ctrl.assigned.length = 0;
				ctrl.total_rows = 0;

                if (badge.assigned instanceof Array) {
                    for (var c = 0; c < badge.assigned.length; c++) {
                        ctrl.assigned.push(badge.assigned[c]);
                    }
                }
                ctrl.total_rows = ctrl.assigned.length;
			};

            // ToDo: Remove these lines when a Claro >=8.10 compatible branch of this module is available
            if (angular.version.major === 1 && angular.version.minor < 5) {
                this.$onInit();
            }
		}
	}
}());
