(function()
{
    var moduleName = 'cla.badges_core';
    var template = require('../../../html/directives/manage/badge_add.html');

    angular.module(moduleName)
        .directive('claBadgeAdd', badgeAdd);

    badgeAdd.$inject = ['claBadgesService'];
    function badgeAdd(service)
    {
        return {
            restrict: 'E',
            templateUrl: template,
            scope: {
                badgeId: '='
            },
            controllerAs: 'ctrl',
            bindToController: true,
            controller: controller
        };

        function controller()
        {
            var ctrl = this;

            this.$onInit = function() {
                ctrl.perms = service.getPerms();
            };

            ctrl.showNewBadge = function($event){
				$event.preventDefault();

				var element = angular.element('cla-badge-add-modal');
				element.trigger('cla-reset', {id: 0});
				element.find('.modal').modal('show');
			};

            // ToDo: Remove these lines when a Claro >=8.10 compatible branch of this module is available
            if (angular.version.major === 1 && angular.version.minor < 5) {
                this.$onInit();
            }
        }
    }
}());
