(function()
{
    var moduleName = 'cla.badges_manage';
    var template = require('../../../html/directives/manage/badge_sort.html');

    angular.module(moduleName)
        .directive('claBadgeSort', badgeSort);

    badgeSort.$inject = ['claBadgesService'];
    function badgeSort(service)
    {
        return {
            restrict: 'E',
            templateUrl: template,
            controllerAs: 'sort',
            bindToController: true,
            controller: controller
        };

        function controller()
        {
            var ctrl = this;

            this.$onInit = function() {
                ctrl.sort = 'title_asc';
            };

            ctrl.onChange = function()
            {
                switch (ctrl.sort)
                {
                    case 'title_asc':
                        service.setSort('title');
                        service.setSortDir('asc');
                        break;
                    case 'title_desc':
                        service.setSort('title');
                        service.setSortDir('desc');
                        break;
                    case 'created_date_asc':
                        service.setSort('created_date');
                        service.setSortDir('asc');
                        break;
                    case 'created_date_desc':
                        service.setSort('created_date');
                        service.setSortDir('desc');
                        break;
                    case 'modified_date_asc':
                        service.setSort('modified_date');
                        service.setSortDir('asc');
                        break;
                    case 'modified_date_desc':
                        service.setSort('modified_date');
                        service.setSortDir('desc');
                        break;
                }
                service.doSort();
            };

            // ToDo: Remove these lines when a Claro >=8.10 compatible branch of this module is available
            if (angular.version.major === 1 && angular.version.minor < 5) {
                this.$onInit();
            }
        }
    }
}());
