(function()
{
    var moduleName = 'cla.badges_core';

    angular.module(moduleName)
        .controller('profileController', profileController);

    profileController.$inject = ['claBadgesService', '$scope', '$timeout'];
    function profileController(service, $scope, $timeout)
    {
        var ctrl = this;

        ctrl.userId = 0;
        ctrl.badges = [];
        ctrl.userBadges = [];

        ctrl.init = function(userId){
            ctrl.onUpdate = function()
            {
                ctrl.userBadges.length = 0;
                var badges = service.getBadges();

                for (var i = 0; i < badges.length; i++)
                {
                    ctrl.userBadges.push(badges[i]);
                }

                ctrl.userId = userId;
                ctrl.badges.length = 0;
                for (i = 0; i < badges.length; i++)
                {
                    ctrl.badges.push(badges[i]);
                }

                $timeout(function(){
                    $scope.$digest();
                }, 0);
            };
            service.registerUpdateCallback(ctrl.onUpdate);
            ctrl.onUpdate();
        };
    }
}());
