<?php

use Claromentis\Core\Services;
use Claromentis\Menu\Infobar\MenuItemApplication;
use Claromentis\Menu\Infobar\MenuItemRepository;

/** @var \Claromentis\Setup\SetupFacade $installer */
$installer->GetPluginsRepository()->Add('badges', 'Claromentis\Badges\BadgesApplication');

$admin_panel = $installer->GetAdminPanelCreator();
$admin_panel->Enable('badges');

$menu = Services::I()->{MenuItemRepository::class};
$menu->save(new MenuItemApplication('badges', 'Badges', '/badges/'));

// Add file storage for badge images
$cdn = Claromentis\Core\Services::I()->GetCDN();

if (!$cdn->IsDir('badges'))
	$cdn->CreateDir('badges');

// Add badge icons
$images = [
	'000-empty.svg',
	'001-goal.svg',
	'002-flag.svg',
	'003-tasks.svg',
	'004-cloud.svg',
	'005-presentation.svg',
	'006-presentation-1.svg',
	'007-briefcase.svg',
	'008-rating.svg',
	'009-rating-1.svg',
	'010-badge.svg',
	'011-trophy.svg',
	'012-clipboard.svg',
	'013-rating-2.svg',
	'014-success.svg',
	'015-rating-3.svg',
	'016-trophy-1.svg',
	'017-flag-1.svg',
	'018-trophy-2.svg',
	'019-handshake.svg',
	'020-employee.svg',
	'021-employee-1.svg',
	'022-goals.svg',
	'023-certificate.svg',
	'024-thinking.svg',
	'025-graduation.svg',
	'026-target.svg',
	'027-calendar.svg',
	'028-idea.svg',
	'029-stopwatch.svg',
	'030-bill.svg',
	'031-ingots.svg',
	'032-diamond.svg',
	'033-padlock.svg',
	'034-bar-chart.svg',
	'035-employee-2.svg',
	'036-employee-3.svg',
	'037-employee-4.svg',
	'038-employee-5.svg',
	'039-badge-1.svg',
	'040-winner.svg',
	'041-goal-1.svg',
	'042-podium.svg',
	'043-medal.svg',
	'044-trophy-3.svg',
	'045-goal-2.svg',
	'046-success-1.svg',
	'047-profits.svg',
	'048-goal-3.svg',
	'049-medal-1.svg',
	'050-exam.svg',
	'042-earth.svg',
	'043-eco-battery.svg',
	'049-recycling-symbol.svg'
];

$db = $installer->GetDb();
foreach ($images as $image)
{
	$db->unsafe_query = true;
	$db->query('INSERT INTO badge_image (set_id, file_name) VALUES (1, str:filename)', $image);
}
