<?php
$_db_migration_to = '01.01'; // 1.0.0-rc
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_initial_schema.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$desc =[
	"id" => "IDENTITY",
	"title" => "VARCHAR(200) DEFAULT NULL",
	"description" => "CLOB DEFAULT NULL",
	"image_id" => "INT NOT_NULL DEFAULT 0",
	"status" => "INT NOT_NULL DEFAULT 0",
	"created_by" => "INT NOT_NULL DEFAULT 0",
	"created_date" => "INT_DATE NOT_NULL DEFAULT 0",
	"modified_by" => "INT DEFAULT NULL",
	"modified_date" => "INT_DATE DEFAULT NULL"
];
$db->CreateTable('badge', $desc);
$db->CreateIndex('badge', 'badge_title', 'title');  // For filtering the list

$desc =[
	"id" => "IDENTITY",
	"set_id" => "INT NOT_NULL DEFAULT 0",
	"created_by" => "INT NOT_NULL DEFAULT 0",
	"created_date" => "INT_DATE NOT_NULL DEFAULT 0"
];
$db->CreateTable('badge_image', $desc);
$db->CreateIndex('badge_image', 'badge_image_set_id', 'set_id'); // To see just badges in a set

$desc =[
	"id" => "IDENTITY",
	"badge_id" => "INT NOT_NULL DEFAULT 0",
	"message" => "CLOB DEFAULT NULL",
	"assigned_to" => "INT NOT_NULL DEFAULT 0",
	"assigned_by" => "INT NOT_NULL DEFAULT 0",
	"assigned_date" => "INT_DATE NOT_NULL DEFAULT 0"
];
$db->CreateTable('badge_award', $desc);
$db->CreateIndex('badge_award', 'badge_award_badge_id', 'badge_id'); // To see who has been awarded a badge
$db->CreateIndex('badge_award', 'badge_award_assigned_to', 'assigned_to'); // To see all badges for a user
DB_UPDATE_FILE
);


$migrations->Run('02_cdn.php', <<<'DB_UPDATE_FILE'
<?php

// Add file storage for badge images
$cdn = Claromentis\Core\Services::I()->GetCDN();
if (!$cdn->IsDir('\badges'))
	$cdn->CreateDir('\badges');

DB_UPDATE_FILE
);


$migrations->Run('02_update_schema.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('badge', 'bg_colour', "VARCHAR(6) NOT_NULL DEFAULT '000'");
$db->AddColumn('badge_image', 'file_name', "VARCHAR(100) DEFAULT NULL");

DB_UPDATE_FILE
);


$migrations->Run('03_default_image_set.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$images = [
	'001-goal.svg',
	'002-flag.svg',
	'003-tasks.svg',
	'004-cloud.svg',
	'005-presentation.svg',
	'006-presentation-1.svg',
	'007-briefcase.svg',
	'008-rating.svg',
	'009-rating-1.svg',
	'010-badge.svg',
	'011-trophy.svg',
	'012-clipboard.svg',
	'013-rating-2.svg',
	'014-success.svg',
	'015-rating-3.svg',
	'016-trophy-1.svg',
	'017-flag-1.svg',
	'018-trophy-2.svg',
	'019-handshake.svg',
	'020-employee.svg',
	'021-employee-1.svg',
	'022-goals.svg',
	'023-certificate.svg',
	'024-thinking.svg',
	'025-graduation.svg',
	'026-target.svg',
	'027-calendar.svg',
	'028-idea.svg',
	'029-stopwatch.svg',
	'030-bill.svg',
	'031-ingots.svg',
	'032-diamond.svg',
	'033-padlock.svg',
	'034-bar-chart.svg',
	'035-employee-2.svg',
	'036-employee-3.svg',
	'037-employee-4.svg',
	'038-employee-5.svg',
	'039-badge-1.svg',
	'040-winner.svg',
	'041-goal-1.svg',
	'042-podium.svg',
	'043-medal.svg',
	'044-trophy-3.svg',
	'045-goal-2.svg',
	'046-success-1.svg',
	'047-profits.svg',
	'048-goal-3.svg',
	'049-medal-1.svg',
	'050-exam.svg',
];

foreach ($images as $image)
{
	$db->unsafe_query = true;
	$db->query('INSERT INTO badge_image (set_id, file_name) VALUES (1, str:filename)', $image);
}
DB_UPDATE_FILE
);


$migrations->Run('04_new_default_image.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->unsafe_query = true;
$db->query("INSERT INTO badge_image (set_id, file_name) VALUES (1, '000-empty.svg')");

DB_UPDATE_FILE
);


$migrations->Run('05_new_images.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$images = [
	'042-earth.svg',
	'043-eco-battery.svg',
	'049-recycling-symbol.svg',
];

foreach ($images as $image)
{
	$db->unsafe_query = true;
	$db->query('INSERT INTO badge_image (set_id, file_name) VALUES (1, str:filename)', $image);
}
DB_UPDATE_FILE
);


$migrations->Run('06_archive_columns.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();
$db->AddColumn('badge', 'archived_date', 'INT_DATE DEFAULT NULL');
$db->AddColumn('badge', 'archived_by', 'INT DEFAULT NULL');

DB_UPDATE_FILE
);


$migrations->Run('07_modified_dates.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->query('UPDATE badge SET modified_date = created_date WHERE modified_date IS NULL');

DB_UPDATE_FILE
);


$migrations->Run('08_shortened_description.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->query('UPDATE badge SET description = left(description, 1000)');
$db->AlterColumn('badge', 'description', 'description', 'VARCHAR(1000) DEFAULT NULL');

DB_UPDATE_FILE
);


$migrations->Run('09_shortened_message.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->query('UPDATE badge_award SET message = left(message, 200)');
$db->AlterColumn('badge_award', 'message', 'message', 'VARCHAR(2000) DEFAULT NULL');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('01.01');
