<?php
// This file contains the database schema version 04.01
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
if ($migrations->GetVersion() > 0)
	throw new Exception("The database is already initialized");
//===========================================================================================

// badge
$table_descr = array(
	'id'	=>	"IDENTITY",
	'title'	=>	"VARCHAR(200) NULL DEFAULT NULL",
	'description'	=>	"VARCHAR(1000) NULL DEFAULT NULL",
	'image_id'	=>	"INT NOT_NULL DEFAULT 0",
	'status'	=>	"INT NOT_NULL DEFAULT 0",
	'created_by'	=>	"INT NOT_NULL DEFAULT 0",
	'created_date'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'modified_by'	=>	"INT NULL DEFAULT NULL",
	'modified_date'	=>	"INT_DATE NULL DEFAULT NULL",
	'bg_colour'	=>	"VARCHAR(6) NOT_NULL DEFAULT '000'",
	'archived_date'	=>	"INT_DATE NULL DEFAULT NULL",
	'archived_by'	=>	"INT NULL DEFAULT NULL",
);

$db->CreateTable('badge', $table_descr, true);
$db->CreateIndex('badge', 'badge_title', 'title');



// badge_award
$table_descr = array(
	'id'	=>	"IDENTITY",
	'badge_id'	=>	"INT NOT_NULL DEFAULT 0",
	'message'	=>	"VARCHAR(2000) NULL DEFAULT NULL",
	'assigned_to'	=>	"INT NOT_NULL DEFAULT 0",
	'assigned_by'	=>	"INT NOT_NULL DEFAULT 0",
	'assigned_date'	=>	"INT_DATE NOT_NULL DEFAULT 0",
);

$db->CreateTable('badge_award', $table_descr, true);
$db->CreateIndex('badge_award', 'badge_award_badge_id', 'badge_id');
$db->CreateIndex('badge_award', 'badge_award_assigned_to', 'assigned_to');



// badge_image
$table_descr = array(
	'id'	=>	"IDENTITY",
	'set_id'	=>	"INT NOT_NULL DEFAULT 0",
	'created_by'	=>	"INT NOT_NULL DEFAULT 0",
	'created_date'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'file_name'	=>	"VARCHAR(100) NULL DEFAULT NULL",
);

$db->CreateTable('badge_image', $table_descr, true);
$db->CreateIndex('badge_image', 'badge_image_set_id', 'set_id');





//===========================================================================================
$migrations->SetVersion('04.01');
