(function()
{
    var template = require('../../html/directives/badge_assignment.html');
    var moduleName = 'cla.badges_core';

    angular.module(moduleName)
        .directive('badgeAssignment', badgeAssignment);

    badgeAssignment.$inject = ['$timeout', '$rootScope', 'claBadgesService', 'badgeAssignmentService', 'growl.service'];
    function badgeAssignment($timeout, $rootScope, badgesService, assignService, growlService)
    {
        return {
            restrict: 'E',
            templateUrl: template,
            scope: {
                badgeId: '@',
                userId: '=',
                userName: '=',
                id: '@',
                shape: '@',
                filterUsers: '@'
            },
            controllerAs: 'assignment',
            bindToController: true,
            controller: controller
        };

        function controller()
        {
            var ctrl = this;
            this.$onInit = function() {
                ctrl.message = '';

                ctrl.modelBadgeId = 0;
                ctrl.modelUserId = 0;

                ctrl.chooseBadge = (typeof ctrl.badgeId === 'undefined');
                ctrl.chooseUser = (typeof ctrl.userId === 'undefined');

                ctrl.assign_image_alttext = lmsg('badges.assign.image.alttext');

                ctrl.userControl = {};
                ctrl.candidates = [];
                ctrl.newAssignees = [];

                ctrl.showAssignedMessage = false;

                ctrl.perms = badgesService.getPerms();

                ctrl.pickerToken = {
                    setBadgeId: function (id) {
                        ctrl.modelBadgeId = id;
                    }
                };

                if (typeof ctrl.badgeId !== 'undefined')
                    ctrl.modelBadgeId = ctrl.badgeId;

                if (typeof ctrl.userId !== 'undefined')
                    ctrl.modelUserId = ctrl.userId;
            };

            ctrl.open = function($event)
            {
                ctrl.message = '';
                ctrl.candidates = [];
                ctrl.newAssignees = [];
                ctrl.showAssignedMessage = false;
                if (ctrl.chooseBadge)
                    ctrl.modelBadgeId = 0;
                $event.preventDefault();

                if (ctrl.pickerToken.reset !== undefined)
                    ctrl.pickerToken.reset();
                if ((ctrl.pickerToken.getAssignableBadgeCount !== undefined) &&
                    (ctrl.pickerToken.getAssignableBadgeCount() < 1))
                {
                    growlService.showSuccess(lmsg('badges.profile.user_has_all_badges'));
                    return;
                }
                assignService.setControl(ctrl.userControl);
                assignService.open(ctrl.id);
            };

            ctrl.assign = function()
            {
                var users = [ctrl.modelUserId];
                if (ctrl.newAssignees.length > 0)
                    users = ctrl.newAssignees;

                if (ctrl.modelBadgeId === 0)
                {
                    growlService.showError(lmsg('badges.assign.validation.no_badge'));
                    return;
                }

                if ((users.length === 1) &&
                    (users[0] === 0))
                {
                    growlService.showError(lmsg('badges.assign.validation.no_users'));
                    return;
                }

                if (ctrl.message.length > 200)
                {
                    growlService.showError(lmsg('badges.assign.validation.message_too_long'));
                    return;
                }

                badgesService.assignBadges(users, [ctrl.modelBadgeId], ctrl.message, function(){
                    assignService.close(ctrl.id);
                }, function(){
                    $timeout(function(){
                        $rootScope.$digest();
                    }, 0);
                });
            };

            ctrl.onUserPickerChange = function()
            {
                ctrl.processAssigneeCandidates();
            };

            ctrl.onBadgeChange = function()
            {
                ctrl.processAssigneeCandidates();
            };

            ctrl.processAssigneeCandidates = function()
            {
                // Get user IDs of those that already have this badge
                var previousAssigned = badgesService.getAssigneesForBadge(parseInt(ctrl.modelBadgeId));
                var previousAssignedUserIds = previousAssigned.map(function(assignee){
                    return assignee.id;
                });

                // Get user IDs of those picked to be assigned now
                var candidateAssigneeUserIds = ctrl.candidates.map(function(assigneeId){
                    return parseInt(assigneeId);
                });

                // Show the message if any user IDs appear in both arrays
                var alreadyAssignedUserIds = candidateAssigneeUserIds.filter(function(candidateId){
                    return previousAssignedUserIds.indexOf(candidateId) >= 0;
                });
                ctrl.showAssignedMessage = alreadyAssignedUserIds.length > 0;

                // Set the actual submitted candidate list to include only those not already assigned
                ctrl.newAssignees.length = 0;
                candidateAssigneeUserIds.filter(function(candidateId){
                    if (previousAssignedUserIds.indexOf(candidateId) === -1)
                        ctrl.newAssignees.push(candidateId);
                });
            };

            ctrl.isActive = function()
            {
                return badgesService.isActive;
            };

            ctrl.canAssign = function()
            {
                if (ctrl.perms.canAssignAny)
                    return true;

                if ((ctrl.perms.canAssignSubordinates) &&
                    ((ctrl.userId === undefined) ||
                     (ctrl.perms.subordinates.indexOf(parseInt(ctrl.userId)) !== -1)))
                {
                    return true;
                }

                return false;
            };

            // ToDo: Remove these lines when a Claro >=8.10 compatible branch of this module is available
            if (angular.version.major === 1 && angular.version.minor < 5) {
                this.$onInit();
            }
        }
    }
}());
