(function()
{
    var moduleName = 'cla.badges_service';

	// Manual singleton as the .service() appears to return multiple instances across Angular apps
	var instance = null;
	if (instance === null)
		instance = new badgeImageService();

    angular.module(moduleName)
        .service('claBadgeImageService', ['$http', 'growl.service', 'imagePreloadFactory', function($http, growlService, preload)
		{
			instance.setHttp($http);
			instance.setGrowlService(growlService);
			instance.init(preload);
			return instance;
		}]);

    function badgeImageService()
    {
        var service = this;
        service.baseUrl = '/api/badges/image-sets';

        service.images = [];

        service.updateCallbacks = [];
        service.assignCallbacks = [];

        service.fetchLatest = function()
        {
            service.$http.get(service.baseUrl + '/images').then(function(data){
                service.init(data.data);
                for (var i = 0; i < service.updateCallbacks.length; i++)
                {
                    service.updateCallbacks[i]();
                }
            }, function(data){
                var error = data.data;
                var title = lmsg('badges.manage.ajax.unknown_error');
                if (typeof data.data === 'object')
                {
                    if (data.data.detail !== undefined)
                    {
                        error = data.data.detail;
                        title = data.data.title;
                    } else
                    {
                        error = data.data.message;
                    }
                }
                service.growlService.showError(title, error);
            });
        };

        service.registerUpdateCallback = function(callback)
        {
            service.updateCallbacks.push(callback);
        };

        service.registerAssignCallback = function(callback)
        {
            service.assignCallbacks.push(callback);
        };

        service.init = function(images)
        {
            service.images.length = 0;

            for (var i = 0; i < images.length; i++)
            {
                service.images.push(images[i]);
            }
        };

        service.getImages = function()
        {
            return service.images;
        };

        service.addImage = function(hash, callback)
        {
            var data = [{
                hash: hash
            }];
            service.$http.post(service.baseUrl + '/0/images', data).then(function(data){
                service.growlService.showSuccess(data.data.message);
                if (callback !== null)
                    callback();
                setTimeout(function(){
                    service.fetchLatest();
                }, 0);
            }, function(data){
                var error = data.data;
                var title = lmsg('badges.manage.ajax.unknown_error');
                if (typeof data.data === 'object')
                {
                    if (data.data.detail !== undefined)
                    {
                        error = data.data.detail;
                        title = data.data.title;
                    } else
                    {
                        error = data.data.message;
                    }
                }
                service.growlService.showError(title, error);
            });
        };

		// Angular can't inject dependencies into a singleton so we have to pass this in manually.
		// Only the first one is saved to avoid any state-change issues being overwritten mid-request.
		service.$http = null;
		service.setHttp = function($http)
		{
			if (service.$http === null)
				service.$http = $http;
		};

		service.growlService = null;
		service.setGrowlService = function(growlService)
		{
			if (service.growlService === null)
				service.growlService = growlService;
		};
    }
}());
