define(['cla_angular', '../../html/directives/badge_list.html'], function (angular, template)
{
	var module = angular.module('cla.badges.badge_list', ['badgePreloadModule', 'cla.core.lmsg']);

	module.directive('claBadgeList', ['badgePreloadFactory', badgeList])

	function badgeList(badgePreloadFactory)
	{
		var controller = function()
		{
			var ctrl = this;

			ctrl.badges = badgePreloadFactory.getBadgeData()

			ctrl.isEarned = function(badge)
			{
				if (!ctrl.showEarnedBadge)
					return false;

				if (badge.assigned !== undefined)
				{
					for (var i = 0; i < badge.assigned.length; i++)
					{
						if ((badge.assigned[i].assigned_to !== undefined) &&
							badge.assigned[i].assigned_to.id === parseInt(ctrl.userId))
						{
							return true;
						}
					}
				}

				return false;
			};
		};

		return {
			controller: controller,
			bindToController: true,
			controllerAs: 'ctrl',
			restrict: 'E',
			templateUrl: template,
			scope: {
				userId: '=',
				showEarnedBadge: '='
			}
		};
	}
});
