define(['cla_angular', '../../html/directives/badges_select.html'], function (angular, template)
{
	var moduleName = 'cla.badges.badges_select';
	var module;

	try {
		module = angular.module(moduleName);
	} catch(err) {
		// Named module does not exist, so create one
		module = angular.module(moduleName, ['cla.badges.options.service']);
	}

	module.filter('decodeSpecialChars', [decodeFilter]);
	module.directive('claBadgesSelect', ['badgesOptionsService', badgesSelect]);

	function decodeFilter()
	{
		function decodeHtml(html) {
			var txt;

			if (typeof(html) === 'object')
			{
				for (var key in html)
				{
					if (html.hasOwnProperty(key))
					{
						txt = document.createElement("textarea");
						txt.innerHTML = html[key];
						html[key] = txt.value;
					}
				}

				return html;
			}

			txt = document.createElement("textarea");
			txt.innerHTML = html;
			return txt.value;
		}

		return function(encoded)
		{
			return decodeHtml(encoded);
		}
	}

	function badgesSelect(service)
	{
		var controller = function()
		{
			var ctrl = this;

			this.$onInit = function () {
				if (ctrl.options && ctrl.options.badges) {
					for (var i = 0; i < ctrl.options.badges.length; i++) {
						if (ctrl.options.badges[i].isSelected) {
							service.addBadgeData(ctrl.options.badges[i]);
						}
					}
				}
			};

			ctrl.badgeToggled = function(option)
			{
				if (option.isSelected)
				{
					ctrl.ngModel.push(option.id);
					service.addBadge(option);
				} else
				{
					var index = ctrl.ngModel.indexOf(option.id);
					if (index > -1)
						ctrl.ngModel.splice(index, 1);

					service.removeBadge(option);
				}
			};
		};

		return {
			controller: controller,
			bindToController: true,
			controllerAs: 'ctrl',
			restrict: 'E',
			require: '^ngModel',
			templateUrl: template,
			scope: {
				ngModel: '=',
				options: '='
			}
		};
	}
});
