(function()
{
    var moduleName = 'cla.badges_service';

    // Manual singleton as the .service() appears to return multiple instances across Angular apps
    var instance = null;
    if (instance === null)
        instance = new EventQueue();

    angular.module(moduleName)
        .factory('claEventQueue', [function()
        {
            return instance;
        }]);

    function EventQueue() {
        var listeners = [];
        return {
            // publish
            send: function(event_name, event_data) {
                angular.forEach(listeners, function(handler) {
                    if (handler['event_name'] === event_name) {
                        handler['callback'](event_data);
                    }
                });
            },
            // subscribe
            onEvent: function(event_name, handler) {
                listeners.push({'event_name': event_name, 'callback': handler});
            }
        };
    }
}());
