(function()
{
	var template = require('../../../html/directives/manage/badge_list.html');
    var moduleName = 'cla.badges_manage';

    angular.module(moduleName)
        .directive('claBadgeList', badgeList);

    badgeList.$inject = ['claBadgesService', 'badgeAssignmentService'];
    function badgeList(service, assignService)
    {
        var controller = function($scope, $timeout)
        {
            var ctrl = this;

            this.$onInit = function() {
                ctrl.badges = [];
                ctrl.perms = service.getPerms();
                service.registerUpdateCallback(ctrl.onUpdate);
                ctrl.onUpdate();
            };

            ctrl.onUpdate = function()
			{
				ctrl.badges.length = 0;
				var badges = service.getBadges();

				for (var i = 0; i < badges.length; i++)
				{
					if (badges[i].status !== 'archived')
						ctrl.badges.push(badges[i]);
				}

				$timeout(function(){
					$scope.$digest();
				}, 0);
			};

			ctrl.isEarned = function(badge)
			{
				if (badge.assigned !== undefined)
				{
					for (var i = 0; i < badge.assigned.length; i++)
					{
						if ((badge.assigned[i].assigned_to !== undefined) &&
							badge.assigned[i].assigned_to.id === parseInt(ctrl.userId))
						{
							return true;
						}
					}
				}

				return false;
			};

			ctrl.edit = function($event, badge)
			{
				$event.preventDefault();

				var element = angular.element('cla-badge-add-modal');
				element.trigger('cla-reset', {id: badge.id});
				element.find('.modal').modal('show');
			};

			ctrl.archive = function($event, badge)
			{
				$event.preventDefault();

				if (confirm(lmsg('badges.manage.archive.confirm')))
					service.saveBadge(badge.id, badge.title, badge.description, badge.imageId, 'archived', badge.colour, undefined, lmsg('badges.list.badge_archived'));
			};

			ctrl.assign = function($event, badge)
			{
				$event.preventDefault();

				assignService.open('badge_assign_from_card-' + badge.id);
			};

            // ToDo: Remove these lines when a Claro >=8.10 compatible branch of this module is available
            if (angular.version.major === 1 && angular.version.minor < 5) {
                this.$onInit();
            }
        };
		controller.$inject = ['$scope', '$timeout'];

         var link = function(scope, element, attrs, ctrl) {
            ctrl.badges.forEach(function(badge) {
                badge.image_alt_text = badge.title + ' ' + lmsg('badges.image.alttext');
            });
        };

		return {
			restrict: 'E',
			templateUrl: template,
			scope: {
				userId: '@',
				filterUsers: '@'
			},
			controllerAs: 'list',
			bindToController: true,
			controller: controller,
            link: link
		};
    }
}());
