(function()
{
    var moduleName = 'cla.badges_manage';
    var template = require('../../../html/directives/manage/keyword_filter.html');

    angular.module(moduleName)
        .directive('claKeywordFilter', keywordFilter);

    keywordFilter.$inject = ['claBadgesService'];
    function keywordFilter(service)
    {
        return {
            restrict: 'E',
            templateUrl: template,
            scope: {},
            controllerAs: 'ctrl',
            bindToController: true,
            controller: controller
        };

        function controller()
        {
            var ctrl = this;

            this.$onInit = function() {
                ctrl.term = '';
            };

            ctrl.onChange = function()
            {
                service.setFilterTerm(ctrl.term);
            };

            // ToDo: Remove these lines when a Claro >=8.10 compatible branch of this module is available
            if (angular.version.major === 1 && angular.version.minor < 5) {
                this.$onInit();
            }
        }
    }
}());
