(function()
{
	var template = require('../../../html/directives/manage/no_badges.html');
    var moduleName = 'cla.badges_manage';

    angular.module(moduleName)
        .directive('claNoBadges', NoBadges);

    NoBadges.$inject = ['claBadgesService'];
    function NoBadges(service)
    {
        var controller = function()
        {
            var ctrl = this;

            this.$onInit = function() {
                ctrl.badges = [];
                ctrl.init(service.getBadges());
                service.registerUpdateCallback(function(){
                    ctrl.init(service.getBadges());
                });
            };

            ctrl.init = function(badges)
            {
                ctrl.badges.length = 0;
                for (var i = 0; i < badges.length; i++)
                {
                    if (badges[i].status === 'live')
                        ctrl.badges.push(badges[i]);
                }
            };

            ctrl.isFiltered = function()
			{
				return service.getFilterTerm() !== '';
			};

            // ToDo: Remove these lines when a Claro >=8.10 compatible branch of this module is available
            if (angular.version.major === 1 && angular.version.minor < 5) {
                this.$onInit();
            }
        };

		return {
			restrict: 'E',
			templateUrl: template,
			scope: {},
			controllerAs: 'ctrl',
			bindToController: true,
			controller: controller
		};
    }
}());
