(function()
{
    var moduleName = 'cla.badges_core';
    var template = require('../../../html/directives/profile/badge_picker.html');

    angular.module(moduleName)
        .directive('claBadgePicker', badgePicker);

    badgePicker.$inject = ['claAssignableBadgesService', 'claUnassignedBadgesService'];
    function badgePicker(assignableService, unassignedService)
    {
        return {
            restrict: 'E',
            templateUrl: template,
            scope: {
                ngModel: '=',
                token: '=',
                restrictById: '='
            },
            controllerAs: 'picker',
            bindToController: true,
            controller: controller,
            link: link
        };

        function controller()
        {
            var ctrl = this;
            this.$onInit = function() {
                ctrl.badges = [];

                ctrl.badgeService = assignableService;
                if (ctrl.restrictById !== undefined)
                {
                    ctrl.badgeService = unassignedService;
                    ctrl.badgeService.setUserId(ctrl.restrictById);
                }
                ctrl.setBadges(ctrl.badgeService.getBadges());
                ctrl.badgeService.registerUpdateCallback(ctrl.callback);

                ctrl.token.reset = function(){
                    ctrl.setBadges(ctrl.badgeService.getBadges());
                    ctrl.token.setBadgeId(ctrl.badgeService.getFirstBadgeId());
                };

                ctrl.token.getAssignableBadgeCount = function(){
                    return ctrl.badges.length;
                };
            };

            ctrl.setBadges = function(badges)
            {
                ctrl.badges.length = 0;
                for (var i = 0; i < badges.length; i++)
                {
                    ctrl.badges.push(badges[i]);
                }
            };

            ctrl.callback = function()
            {
                ctrl.setBadges(ctrl.badgeService.getBadges());
            };

            // ToDo: Remove these lines when a Claro >=8.10 compatible branch of this module is available
            if (angular.version.major === 1 && angular.version.minor < 5) {
                this.$onInit();
            }
        }

        function link(scope, element, attr, ctrl) {
            ctrl.onChange = function(value){
                element.closest('cla-badge-picker').trigger('change');
            };

            ctrl.badges.forEach(function(badge) {
                badge.image_alt_text = badge.title + ' ' + lmsg('badges.image.alttext');
            });
        }
    }
}());
