(function()
{
    var moduleName = 'cla.badges_core';
    var template = require('../../../html/directives/profile/badge_single.html');

    angular.module(moduleName)
        .directive('claBadgeSingle', badgeSingle);

    badgeSingle.$inject = ['claBadgesService'];
    function badgeSingle(service)
    {
        return {
            restrict: 'E',
            templateUrl: template,
            scope: {
                badgeId: '='
            },
            controllerAs: 'badge',
            bindToController: true,
            controller: controller,
            link: link
        };

        function controller()
        {
            var ctrl = this;
            this.$onInit = function() {
                ctrl.badge = {};

                var badges = service.getBadges();
                for (var i = 0; i < badges.length; i++) {
                    if (badges[i].id == ctrl.badgeId)
                        ctrl.badge = badges[i];
                }
            };

            // ToDo: Remove these lines when a Claro >=8.10 compatible branch of this module is available
            if (angular.version.major === 1 && angular.version.minor < 5) {
                this.$onInit();
            }
        }

        function link(scope, element, attrs, ctrl) {
            ctrl.badge.image_alt_text = ctrl.badge.title + ' ' + lmsg('badges.image.alttext');
        }
    }
}());
