(function()
{
    var moduleName = 'cla.badges_core';
    var template = require('../../../html/directives/profile/badge_list.html');

    var DISPLAY_ASSIGNEE_COUNT = 4;

    angular.module(moduleName)
        .directive('claProfileBadgeList', profile_badge_list)
        .filter('shortDescriptionFilter', function() {
            return function(input) {
                if (input == null){
                    return '';
                }
                if (input.length > 250)
                    input = input.substr(0, 247) + '...';
                return input;
            };
        });

    profile_badge_list.$inject = ['claMyBadgesService'];
    function profile_badge_list(service)
    {
        return {
            restrict: 'E',
            templateUrl: template,
            scope: {
                userId: '@',
                userName: '@'
            },
            controllerAs: 'ctrl',
            bindToController: true,
            controller: controller,
        };

        function controller()
        {
            var ctrl = this;
            this.$onInit = function() {
                ctrl.userBadges = [];
                ctrl.perms = service.getPerms();

                ctrl.extractUserBadges(service.getBadges());
                service.setUserId(ctrl.userId);
                service.registerUpdateCallback(function () {
                    ctrl.extractUserBadges(service.getBadges())
                });
            };

            ctrl.extractUserBadges = function(badges)
            {
                ctrl.userBadges.length = 0;
                for (var i = 0; i < badges.length; i++)
                {
                    if (badges[i].assignees !== undefined)
                    {

                        var badge = badges[i];
                        var assignees = badge.assignees;
                        var assignee_total = badge.assignee_total;
                        badge.moreAssignees = [];

                        badge.image_alt_text = badge.title + ' ' + lmsg('badges.image.alttext');

                        for (j = 0; j < assignees.length; j++)
                        {
                            if (j == DISPLAY_ASSIGNEE_COUNT)
                                break;
                            badge.moreAssignees.push(assignees[j]);
                        }

                        badge.moreAssigneesCount = 0;
                        if (assignee_total > DISPLAY_ASSIGNEE_COUNT)
                            badge.moreAssigneesCount = assignee_total - DISPLAY_ASSIGNEE_COUNT;

                        ctrl.userBadges.push(badge);
                    }
                }
            };

            ctrl.getSmalltext = function(badge)
            {
                if (badge.assigned_to_me == null) {
                    return '';
                }

                var msg = lmsg('badges.badge_info.assigned_info', badge.assigned_to_me.assigned_date.date.date_str, badge.assigned_to_me.assigned_by.name);
                if (badge.assigned_to_me.message !== '')
                    msg = msg + ' - ' + badge.assigned_to_me.message;
                return msg;
            };

            ctrl.isThisASubordinate = function()
            {
                return (ctrl.perms.subordinates.indexOf(ctrl.userId) !== -1);
            };

            ctrl.canAssign = function()
            {
                if (ctrl.perms.canAssignAny)
                    return true;

                if ((ctrl.perms.canAssignSubordinates) &&
                    (ctrl.perms.subordinates.indexOf(parseInt(ctrl.userId)) !== -1))
                {
                    return true;
                }

                return false;
            };

            // ToDo: Remove these lines when a Claro >=8.10 compatible branch of this module is available
            if (angular.version.major === 1 && angular.version.minor < 5) {
                this.$onInit();
            }


            angular.element(document).ready(function() {
                $(function () {
                    var popoverElements = $('[data-badge-popover="popover"]');
                    initPopover(popoverElements);

                    function initPopover(popoverTargets) {
                        $(popoverTargets).each(function(i, popoverTarget) {
                            $(this).popover({
                                placement : 'bottom',
                                trigger : 'focus',
                                html: true,
                                sanitize: false,
                                content: function () {
                                    return $('#badge-content-' + $(this).data('popoverId')).html();
                                }
                            });
                        });
                    }
                })
            })
        }
    }
}());
