(function()
{
    var moduleName = 'cla.badges_service';

	// Manual singleton as the .service() appears to return multiple instances across Angular apps
	var instance = null;
	if (instance === null)
		instance = new BadgesService();

    angular.module(moduleName)
        .service('claSingleBadgeService', ['$http', 'growl.service', 'badgePreloadFactory', 'claEventQueue', function($http, growlService, preload, eventQueue)
		{
			instance.setHttp($http);
			instance.setGrowlService(growlService);
			instance.setEventQueue(eventQueue);
			instance.init({
                single_badge: preload.single_badge,
                perms: preload.perms
			});
			return instance;
		}]);

    function BadgesService()
    {
        var service = this;
        service.baseUrl = '/api/badges';

        service.badge = {
            id: 0,
            title: '',
            description: '',
            created_by: {
                id: 0,
                name: ''
            },
            created_date: {
                date_str: '',
                timezone: '',
                date: 20010101010100
            },
            modified_by: {
                id: 0,
                name: ''
            },
            modified_date: {
                date_str: '',
                timezone: '',
                date: 20010101010100
            },
            archived_by: {
                id: 0,
                name: ''
            },
            archived_date: {
                date_str: '',
                timezone: '',
                date: 20010101010100
            },
            assigned: [],
            assignees: [],
            background_colour: '4499cc',
            image: '/intranet/badges/images/000-placeholder.svg',
            image_alt_text: '',
            status: 'archived'
        };
        service.perms = {
            canManage: false,
            canAssignAny: false,
            canAssignSubordinates: false,
            canAssign: false,
            subordinates: []
        };
        service.isActive = false;

        service.updateCallbacks = [];
        service.assignCallbacks = [];

        service.fetchLatest = function()
        {
            if (service.badge.id === 0)
                return;

            service.isActive = true;
            service.$http.get(service.baseUrl + '/badges/' + service.badge.id + '?include_assignees=true').then(function(data){
                service.isActive = false;
                service.init({
                    single_badge: data.data,
                    perms: service.perms
                });
                for (var i = 0; i < service.updateCallbacks.length; i++)
                {
                    service.updateCallbacks[i]();
                }
            }, function(data){
                service.isActive = false;
                var error = data.data;
                var title = lmsg('badges.manage.ajax.unknown_error');
                if (typeof data.data === 'object')
                {
                    if (data.data.detail !== undefined)
                    {
                        error = data.data.detail;
                        title = data.data.title;
                    } else
                    {
                        error = data.data.message;
                    }
                }
                service.growlService.showError(title, error);
            });
        };

        service.registerUpdateCallback = function(callback)
        {
            service.updateCallbacks.push(callback);
        };

        service.registerAssignCallback = function(callback)
        {
            service.assignCallbacks.push(callback);
        };

        service.init = function(data)
        {
            // This service is used by the breadcrumb which is also on the badge list page where there
            // is no single badge, so exit early if tried.
            if (data.single_badge === undefined)
                return;

            service.badge.id = data.single_badge.id;
            service.badge.title = data.single_badge.title;
            service.badge.description = data.single_badge.description;
            service.badge.created_by.id = data.single_badge.created_by.id;
            service.badge.created_by.name = data.single_badge.created_by.name;
            service.badge.created_date.date_str = data.single_badge.created_date.date_str;
            service.badge.created_date.timezone = data.single_badge.created_date.timezone;
            service.badge.created_date.date = data.single_badge.created_date.date;
            service.badge.modified_by.id = data.single_badge.modified_by.id;
            service.badge.modified_by.name = data.single_badge.modified_by.name;
            service.badge.modified_date.date_str = data.single_badge.modified_date.date_str;
            service.badge.modified_date.timezone = data.single_badge.modified_date.timezone;
            service.badge.modified_date.date = data.single_badge.modified_date.date;
            service.badge.archived_by.id = data.single_badge.archived_by.id;
            service.badge.archived_by.name = data.single_badge.archived_by.name;
            service.badge.archived_date.date_str = data.single_badge.archived_date.date_str;
            service.badge.archived_date.timezone = data.single_badge.archived_date.timezone;
            service.badge.archived_date.date = data.single_badge.archived_date.date;
            service.badge.background_colour = data.single_badge.background_colour;
            service.badge.status = data.single_badge.status;
            service.badge.image = data.single_badge.image;
            service.badge.image_alt_text = data.single_badge.title + ' ' + lmsg('badges.image.alt');
            service.badge.assigned.length = 0;
            if (data.single_badge.assigned !== undefined)
            {
                for (var i = 0; i < data.single_badge.assigned.length; i++)
                {
                    service.badge.assigned.push(data.single_badge.assigned[i]);
                }
            }
            service.badge.assignees.length = 0;
            if (data.single_badge.assignees !== undefined)
            {
                for (i = 0; i < data.single_badge.assignees.length; i++)
                {
                    service.badge.assignees.push(data.single_badge.assignees[i]);
                }
            }

            var perms = data.perms;
            service.perms.canManage = perms.canManage;
            service.perms.canAssignAny = perms.canAssignAny;
            service.perms.canAssignSubordinates = perms.canAssignSubordinates;
            service.perms.canAssign = perms.canAssignAny || perms.canAssignSubordinates;
            service.perms.subordinates = perms.subordinates;
        };

        service.getBadge = function()
        {
            return service.badge;
        };

        service.assignBadges = function(userIds, badgeIds, message, callback, failCallback)
        {
            service.isActive = true;
			service.$http.post(service.baseUrl + '/badges/assign', {
                "badge_ids": badgeIds,
                "user_ids": userIds,
                "message": message
            }).then(function(data){
                service.isActive = false;
				service. growlService.showSuccess(lmsg('badges.success.badge_assigned'));

                service.eventQueue.send('badges.update_data');
                if (typeof callback === 'function')
                    callback();
            }, function(data){
                service.isActive = false;
                var error = data.data;
                var title = lmsg('badges.manage.ajax.unknown_error');
                if (typeof data.data === 'object')
                {
                    if (data.data.detail !== undefined)
                    {
                        error = data.data.detail;
                        title = data.data.title;
                    } else
                    {
                        error = data.data.message;
                    }
                }
                if (typeof failCallback === 'function')
                    failCallback();
                service.growlService.showError(title, error);
            });
        };

	    service.unassignBadges = function(userIds, badgeId, message, callback, failCallback)
	    {
            service.isActive = true;
		    service.$http.post(service.baseUrl + '/badges/' + badgeId + '/unassign', {
			    "user_ids": userIds,
			    "message": message
		    }).then(function(data){
                service.isActive = false;
			    service. growlService.showSuccess(lmsg('badges.success.badge_unassigned'));

                service.eventQueue.send('badges.update_data');
                if (typeof callback === 'function')
                    callback();
		    }, function(data){
                service.isActive = false;
                var error = data.data;
                var title = lmsg('badges.manage.ajax.unknown_error');
                if (typeof data.data === 'object')
                {
                    if (data.data.detail !== undefined)
                    {
                        error = data.data.detail;
                        title = data.data.title;
                    } else
                    {
                        error = data.data.message;
                    }
                }
                if (typeof failCallback === 'function')
                    failCallback();
                service.growlService.showError(title, error);
		    });
	    };

        service.saveBadge = function(id, title, description, imageId, status, colour, callback, failCallback, successMessage)
        {
            var data = {};
            if (id === 0)
            {
                data = {
                    title: title,
                    description: description,
                    image_id: imageId,
                    status: 'live',
                    background_colour: colour
                };

                service.isActive = true;
                service.$http.post(service.baseUrl + '/badges', data).then(function(data){
                    service.isActive = false;
                    var message = successMessage === undefined ? data.data.message : successMessage;
                    service.growlService.showSuccess(message);
                    if (typeof callback === 'function')
                        callback();
                    service.eventQueue.send('badges.update_data');
                }, function(data){
                    service.isActive = false;
                    var error = data.data;
                    var title = lmsg('badges.manage.ajax.unknown_error');
                    if (typeof data.data === 'object')
                    {
                        if (data.data.detail !== undefined)
                        {
                            error = data.data.detail;
                            title = data.data.title;
                        } else
                        {
                            error = data.data.message;
                        }
                    }
                    if (typeof failCallback === 'function')
                        failCallback();
                    service.growlService.showError(title, error);
                });
            } else
            {
                data = {
                    title: title,
                    description: description,
                    image_id: imageId,
                    status: status,
                    background_colour: colour
                };

                service.isActive = true;
                service.$http.put(service.baseUrl + '/badges/' + id, data).then(function(data){
                    service.isActive = false;
                    var message = successMessage === undefined ? data.data.message : successMessage;
                    service.growlService.showSuccess(message);
                    if (typeof callback === 'function')
                        callback();
                    service.eventQueue.send('badges.update_data');
                }, function(data){
                    service.isActive = false;
                    var error = data.data;
                    var title = lmsg('badges.manage.ajax.unknown_error');
                    if (typeof data.data === 'object')
                    {
                        if (data.data.detail !== undefined)
                        {
                            error = data.data.detail;
                            title = data.data.title;
                        } else
                        {
                            error = data.data.message;
                        }
                    }
                    if (typeof failCallback === 'function')
                        failCallback();
                    service.growlService.showError(title, error);
                });
            }
        };

        service.getPerms = function()
        {
            return service.perms;
        };

		// Angular can't inject dependencies into a singleton so we have to pass this in manually.
		// Only the first one is saved to avoid any state-change issues being overwritten mid-request.
		service.$http = null;
		service.setHttp = function($http)
		{
			if (service.$http === null)
				service.$http = $http;
		};

		service.growlService = null;
		service.setGrowlService = function(growlService)
		{
			if (service.growlService === null)
				service.growlService = growlService;
		};

        service.eventQueue = null;
        service.setEventQueue = function(eventQueue)
        {
            if (service.eventQueue === null)
            {
                service.eventQueue = eventQueue;

                // Register the update handler
                service.eventQueue.onEvent('badges.update_data', function(){
                    service.fetchLatest()
                });
            }
        };
    }
}());
