(function()
{
    var moduleName = 'cla.badges_service';

	// Manual singleton as the .service() appears to return multiple instances across Angular apps
	var instance = null;
	if (instance === null)
		instance = new UnassignedBadgesService();

    angular.module(moduleName)
        .service('claUnassignedBadgesService', ['$http', 'growl.service', 'badgePreloadFactory', 'claEventQueue', function($http, growlService, preload, eventQueue)
		{
			instance.setHttp($http);
			instance.setGrowlService(growlService);
            instance.setEventQueue(eventQueue);
            instance.init({
                badge_list: preload.unassigned_badges,
                perms: preload.perms
            });
			return instance;
		}]);

    function UnassignedBadgesService()
    {
        var service = this;
        service.baseUrl = '/api/badges';

        service.filterTerm = '';
        service.badge_id = null;
        service.badges = [];
        service.perms = {
            canManage: false,
            canAssignAny: false,
            canAssignSubordinates: false,
            canAssign: false,
            subordinates: []
        };
        service.isActive = false;
        service.userId = 0;

        service.updateCallbacks = [];
        service.assignCallbacks = [];

        service.fetchLatest = function()
        {
            service.isActive = true;
            service.$http.get(service.baseUrl + '/badges?include_assignees=true&not_assigned_to=' + service.userId).then(function(data){
                service.isActive = false;
                service.init({
                    badge_list: data.data,
                    perms: service.perms
                });
                for (var i = 0; i < service.updateCallbacks.length; i++)
                {
                    service.updateCallbacks[i]();
                }
            }, function(data){
                service.isActive = false;
                var error = data.data;
                var title = lmsg('badges.manage.ajax.unknown_error');
                if (typeof data.data === 'object')
                {
                    if (data.data.detail !== undefined)
                    {
                        error = data.data.detail;
                        title = data.data.title;
                    } else
                    {
                        error = data.data.message;
                    }
                }
                service.growlService.showError(title, error);
            });
        };

        service.registerUpdateCallback = function(callback)
        {
            service.updateCallbacks.push(callback);
        };

        service.registerAssignCallback = function(callback)
        {
            service.assignCallbacks.push(callback);
        };

        service.init = function(data)
        {
            var badges = data.badge_list;
            var perms = data.perms;

            service.badges.length = 0;
            for (var i = 0; i < badges.length; i++)
            {
                service.badges.push(badges[i]);
            }

            service.perms.canManage = perms.canManage;
            service.perms.canAssignAny = perms.canAssignAny;
            service.perms.canAssignSubordinates = perms.canAssignSubordinates;
            service.perms.canAssign = perms.canAssignAny || perms.canAssignSubordinates;
            service.perms.subordinates = perms.subordinates;

            if (data.badge_id !== undefined)
            {
            	service.badge_id = data.badge_id;
            }
        };

        service.getBadges = function()
        {
            return service.badges;
        };

        service.getPerms = function()
        {
            return service.perms;
        };

        service.setUserId = function(userId)
        {
            service.userId = userId;
        };

		// Angular can't inject dependencies into a singleton so we have to pass this in manually.
		// Only the first one is saved to avoid any state-change issues being overwritten mid-request.
		service.$http = null;
		service.setHttp = function($http)
		{
			if (service.$http === null)
				service.$http = $http;
		};

		service.growlService = null;
		service.setGrowlService = function(growlService)
		{
			if (service.growlService === null)
				service.growlService = growlService;
		};

        service.eventQueue = null;
        service.setEventQueue = function(eventQueue)
        {
            if (service.eventQueue === null)
            {
                service.eventQueue = eventQueue;

                // Register the update handler
                service.eventQueue.onEvent('badges.update_data', function(){
                    service.fetchLatest()
                });
            }
        };

        service.getFirstBadgeId = function()
        {
            if (service.badges.length === 0)
                return 0;

            var firstItem = service.badges.find(function(x) {
                return x!==undefined
            });

            if (firstItem !== undefined)
                return firstItem.id;

            return 0;
        };
    }
}());
