<?php

/** @var \Claromentis\Setup\SetupFacade $installer */

use Claromentis\Buttons\Permissions;
use Claromentis\Core\Services;
use Claromentis\Menu\Infobar\MenuItemApplication;
use Claromentis\Menu\Infobar\MenuItemRepository;

$installer->GetPluginsRepository()->Add('buttons', 'Claromentis\Buttons\ButtonsApplication');

$admin_panel = $installer->GetAdminPanelCreator();
$admin_panel->Enable('buttons');

$menu = Services::I()->{MenuItemRepository::class};
$menu->save(new MenuItemApplication('buttons', 'Buttons', '/buttons/'));

$db = $installer->GetDb();

/**
 * Allow admin to edit buttons
 *
 * @see Permissions::PERMS_CLASS_BUTTON_ADMIN
 */
$db->query(
	"INSERT INTO permissions (class_id, object_id, perm_owner_class_id, perm_owner_id, rights) VALUES
	(int:class, int:site_id, int:oclass, 1, int:rights)",
	143, 1, 1, 1
);

$data_dir = $installer->GetDataDir();

if (!is_dir("$data_dir/buttons")) {
	mkdir("$data_dir/buttons", 0777);
	chmod("$data_dir/buttons", 0777);
}
