// Internet Explorer fallback for buttons grid layout
function layoutButtonsIe(target){
  var buttons = target.find($('.button'));
  var buttonWrapper = target.find($('.button-wrapper'));
  buttonWrapper.addClass('ie');

  //Calculates the grid layout and assigns css attributes and values
  function gridIeCalc(gridButtons, wrapOn, gridGap){
    var currentRow = 1;
    var currentColumn = 1;

    // repeat specified number of grid columns
    function gridColumns(wrap){
      String.prototype.repeat = function(times) {
        return (new Array(times + 1)).join(this);
      };
      return ("minmax(150px, 1fr) ").repeat(wrap);
    }
    buttonWrapper.css({
      "-ms-grid-columns" : gridColumns(wrapOn)
    })

    // Assign MS grid row and column values
    gridButtons.each(function(i){
      if(currentColumn > wrapOn) {
        currentColumn = 1;
        currentRow = currentRow + 1;
      }

      gridGap = (gridGap / 2).toString();

      $(this).css({
        "-ms-grid-row" : currentRow.toString(),
        "-ms-grid-column" : currentColumn.toString(),
      })

      currentColumn = currentColumn + 1;
    })

    //remove top and bottom margin from buttons
    gridButtons.each(function(i){
      if ($(this).css('-ms-grid-row') === '1') {
        $(this).css({
          "margin-top" : 0,
        })
      }
      if ($(this).css('-ms-grid-row') == currentRow) {
        $(this).css({
          "margin-bottom" : 0,
        })
      }
    })

    //calculate button height
    buttons.css({
      "height" : ((buttonWrapper.height() / currentRow)  - 5).toString(),
    })
  }
  var pagesSixGrid = target.data("gs-max-width") === 6;
  var fullWidthMode = $("body").hasClass("full-width-mode");

  // Calculate button columns at different number of buttons, tile, grid and window widths
    switch (target.data("gs-width")) {
        case 1:
            if (pagesSixGrid) {
                gridIeCalc(buttons, 1, 10)
            } else {
                if (buttons.length === 1) {
                    gridIeCalc(buttons, 1, 10)
                } else {
                    if ($(window).width() < 992) {
                        gridIeCalc(buttons, 1, 10)
                    } else {
                        gridIeCalc(buttons, 2, 10)
                    }
                }
            }
            break;
        case 2:
            if (pagesSixGrid) {
                if (buttons.length < 2) {
                    gridIeCalc(buttons, buttons.length, 10)
                } else {
                    gridIeCalc(buttons, 2, 10)
                }
            } else {
                if (buttons.length < 3) {
                    gridIeCalc(buttons, buttons.length, 10)
                } else {
                    if ($(window).width() < 992) {
                        gridIeCalc(buttons, 2, 10)
                    } else {
                        gridIeCalc(buttons, 3, 10)
                    }
                }
            }

            break;
        case 3:
            if (pagesSixGrid) {
                if (buttons.length < 3) {
                    gridIeCalc(buttons, buttons.length, 10)
                } else {
                    if ($(window).width() < 576) {
                        gridIeCalc(buttons, 2, 10)
                    } else {
                        gridIeCalc(buttons, 3, 10)
                    }
                }
            } else {
                if (buttons.length < 5) {
                    gridIeCalc(buttons, buttons.length, 10)
                } else {
                    if ($(window).width() < 576) {
                        gridIeCalc(buttons, 2, 10)
                    } else if ($(window).width() < 870) {
                        gridIeCalc(buttons, 3, 10)
                    } else if ($(window).width() < 1060) {
                        gridIeCalc(buttons, 4, 10)
                    } else {
                        gridIeCalc(buttons, 5, 10)
                    }
                }
            }
            break;
        case 4:
            if (fullWidthMode) {
                if (buttons.length < 7) {
                    gridIeCalc(buttons, buttons.length, 10)
                } else {
                    if ($(window).width() < 576) {
                        gridIeCalc(buttons, 2, 10)
                    } else if ($(window).width() < 768) {
                        gridIeCalc(buttons, 3, 10)
                    } else if ($(window).width() < 992) {
                        gridIeCalc(buttons, 4, 10)
                    } else if ($(window).width() < 1200) {
                        gridIeCalc(buttons, 6, 10)
                    } else {
                        gridIeCalc(buttons, 7, 10)
                    }
                }
            } else {
                if (pagesSixGrid) {
                    if (buttons.length < 4) {
                        gridIeCalc(buttons, buttons.length, 10)
                    } else {
                        if ($(window).width() < 576) {
                            gridIeCalc(buttons, 2, 10)
                        } else if ($(window).width() < 768) {
                            gridIeCalc(buttons, 3, 10)
                        } else {
                            gridIeCalc(buttons, 4, 10)
                        }
                    }
                } else {
                    if (buttons.length < 6) {
                        gridIeCalc(buttons, buttons.length, 10)
                    } else {
                        if ($(window).width() < 576) {
                            gridIeCalc(buttons, 2, 10)
                        } else if ($(window).width() < 768) {
                            gridIeCalc(buttons, 3, 10)
                        } else if ($(window).width() < 992) {
                            gridIeCalc(buttons, 4, 10)
                        } else {
                            gridIeCalc(buttons, 6, 10)
                        }
                    }
                }
            }
            break;
        case 5:
            if (buttons.length < 6) {
                gridIeCalc(buttons, buttons.length, 10)
            } else {
                if ($(window).width() < 576) {
                    gridIeCalc(buttons, 2, 10)
                } else if ($(window).width() < 768) {
                    gridIeCalc(buttons, 3, 10)
                } else if ($(window).width() < 992) {
                    gridIeCalc(buttons, 4, 10)
                } else if ($(window).width() < 1200) {
                    gridIeCalc(buttons, 5, 10)
                } else {
                    gridIeCalc(buttons, 6, 10)
                }
            }
            break;
        case 6:
            if (buttons.length < 7) {
                gridIeCalc(buttons, buttons.length, 10)
            } else {
                if ($(window).width() < 576) {
                    gridIeCalc(buttons, 2, 10)
                } else if ($(window).width() < 768) {
                    gridIeCalc(buttons, 3, 10)
                } else if ($(window).width() < 992) {
                    gridIeCalc(buttons, 4, 10)
                } else if ($(window).width() < 1200) {
                    gridIeCalc(buttons, 5, 10)
                } else {
                    gridIeCalc(buttons, 7, 10)
                }
            }
            break;
        default:
            if (buttons.length < 6) {
                gridIeCalc(buttons, buttons.length, 10)
            } else {
                gridIeCalc(buttons, 8, 10)
            }
            break;
    }
};
