define(['cla_angular', 'jquery'], function (angular, $) {
	var moduleName = 'cla.button_editor.service';

	var iconWrapper = '.icon-picker-wrapper';
	var activeIcon = '.icon_selected';

	function scrollToIcon() {

		if ($(iconWrapper).length) {
      var scollPosition = $(iconWrapper).scrollTop() + ($(activeIcon).offset().top - $(iconWrapper).offset().top);
			$(iconWrapper).scrollTop(scollPosition);
		}
	}



	angular.module(moduleName, [])
		.service('buttonEditorService', buttonEditorService);

	buttonEditorService.$inject = ['$rootScope', '$timeout'];
	function buttonEditorService($rootScope, $timeout)
	{

		var service = this;

		service.status = {
			selectedId: 0
		};
		service.narrowMode = true;
		service.suggestedTags = [];

		service.init = function(suggestedTags)
		{
			service.suggestedTags = suggestedTags;
		};

		service.setSelectedId = function(id) {

			service.status.selectedId = id;

			var modal = $('#editModal');

			if ((id !== 0) && (service.narrowMode)) {
				modal.modal();

				modal.on('hidden.bs.modal', function(){
					id = 0;
					service.status.selectedId = 0;
				});

			}

			if (id === 0) {
				if (modal.hasClass('in')) {
					modal.modal('hide');
				}
			}
      setTimeout(function () {
      scrollToIcon();
      }, 10);
		};

		service.setWidth = function(width)
		{
			service.narrowMode = width <= 992;

			// The edit directive needs to show/hide the editors depending on narrowMode so force a digest to let it update
			$timeout(function()
			{
				$rootScope.$digest();
			}, 0);
		};

		service.getSuggestedTags = function()
		{
			return service.suggestedTags;
		};

	}
});
