define(['cla_angular', '../../html/directives/button_order_item.html'], function (angular, template)
{
	var moduleName = 'cla.buttons.button_order_item';
	var module;
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, ['cla.buttons.options.service', 'ui.sortable']);
	}

	module.directive('claButtonOrderItem', ['buttonsOptionsService', buttonOrderItem]);

	function buttonOrderItem(service)
	{
		var controller = function()
		{
			var ctrl = this;

            this.$onInit = function() {
                ctrl.uid = Math.random();
                ctrl.button = service.getButtonData(ctrl.buttonId);
            };
		};

		return {
			controller: controller,
			bindToController: true,
			controllerAs: 'ctrl',
			restrict: 'E',
			require: '^ngModel',
			templateUrl: template,
			scope: {
				buttonId: '@'
			}
		};
	}
});
