define(['cla_angular', '../../html/directives/buttons_add.html'], function (angular, template)
{
	var moduleName = 'cla.buttons.manage_header';
	var module;
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, []);
	}

	module.directive('buttonsAdd', buttonsAdd);

	buttonsAdd.$inject = ['buttonsService'];
	function buttonsAdd(service)
	{
		var controller = function()
		{
			var ctrl = this;

			ctrl.clicked = function($event)
			{
				$event.preventDefault();

				service.newButton();
			};
		};

		return {
			controller: controller,
			bindToController: true,
			controllerAs: 'ctrl',
			restrict: 'E',
			templateUrl: template,
			scope: {}
		};
	}
});