define(['cla_angular', '../../html/directives/buttons_list.html'], function (angular, template)
{
	var moduleName = 'cla.buttons.manage';
	var module;
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, []);
	}

	module.directive('buttonsList', buttonsList);

	buttonsList.$inject = ['buttonsService', 'buttonEditorService'];
	function buttonsList(service, editorService)
	{
		var controller = function($scope, $timeout)
		{
			var ctrl = this;

			ctrl.service = service;
			ctrl.selected = 0;
			ctrl.buttons = service.getButtons();
			ctrl.buttonService = service;
			ctrl.editorService = editorService;

			ctrl.totalButtonCount = function()
			{
				return service.getTotalButtonCount();
			};

			ctrl.filteredCallback = function()
			{
				$timeout(function()
				{
					// Search is in another AngularJS app so updates to it's controls won't have triggered a digest in this one.
					$scope.$digest();
				}, 0);
			};
			service.registerFilteredCallback(ctrl.filteredCallback);

			editorService.setWidth(angular.element(window).width());

			angular.element(window).on('resize', function()
			{
				editorService.setWidth(angular.element(window).width());
			});
		};
		controller.$inject = ['$scope', '$timeout'];

		return {
			controller: controller,
			bindToController: true,
			controllerAs: 'list',
			restrict: 'E',
			templateUrl: template,
			scope: {}
		};
	}
});
