define(['cla_angular'], function (angular)
{
	var moduleName = 'cla.buttons.options.service';

	angular.module(moduleName, [])
		.service('buttonsOptionsService', ButtonsService);

	function ButtonsService()
	{
		var service = this;
		service.callback = null;

		service.buttons_order = [];
		service.buttons_data = [];

		service.register_callback = function (callback) {
			service.callback = callback;
		};

		service.addButton = function (button) {
			if (!service.buttonExists(button))
			{
				service.addButtonData(button);
				service.addButtonOrder(button.id);
			}
		};

		service.removeButton = function (button) {

			var index = null;
			var order_index = null;

			for (var i = 0; i < service.buttons_data.length; i++)
			{
				if (button.id === service.buttons_data[i].id)
				{
					index = i;
					order_index = service.buttons_order.indexOf(service.buttons_data[i].id);
					break;
				}
			}

			if (index !== null)
				service.buttons_data.splice(index, 1);

			if(order_index !== -1)
				service.buttons_order.splice(order_index, 1);

			if (service.callback !== null)
				service.callback();

		};

		service.addButtonOrder = function (button_id) {
			service.buttons_order.push(button_id);
			if (service.callback !== null)
				service.callback();
		};

		service.addButtonData = function (button) {
			service.buttons_data.push(button);
		};

		service.buttonExists = function (button) {

			var button_exists = false;
			for (var i = 0; i < service.buttons_data.length; i++)
			{
				if (button.id === service.buttons_data[i].id)
					button_exists = true;
			}

			return button_exists;
		};

		service.getButtonData = function (button_id) {
			for (var i = 0; i < service.buttons_data.length; i++)
			{
				if (service.buttons_data[i].id == button_id)
				{
					return service.getButtonItemData(service.buttons_data[i]);
				}
			}
			return {};
		};

		service.getButtonItemData = function (button) {
			var data = {};
			data.title = button.title;
			data.image = button.image;
			data.background_colour = button.background_colour;
			data.isHidden = button.isHidden;
			data.icon = button.icon;
			data.icon_colour = button.icon_colour;
			data.id = button.id;

			return data;
		};

		service.compareButtonDataAndOrder = function () {
			var buttons_ids = [];
			for (var i = 0; i < service.buttons_data.length; i++)
				buttons_ids.push(service.buttons_data[i].id);

			for (var i = 0; i < buttons_ids.length; i++)
			{
				if (service.buttons_order.indexOf(buttons_ids[i]) === -1)
					service.addButtonOrder(buttons_ids[i]);
			}

			var i = service.buttons_order.length;
			while (i--) {
				if (buttons_ids.indexOf(service.buttons_order[i]) === -1)
					service.buttons_order.splice(i, 1);

			}
			service.callback();
		};

        service.areAnySelectedButtonsHidden = function() {
            for (var i = 0; i < service.buttons_data.length; i++)
            {
                if (service.buttons_data[i].isHidden &&
                    service.buttons_order.indexOf(service.buttons_data[i].id) >= 0)
                {
                    return true;
                }
            }
            return false;
        }
	}
});
