define(['cla_angular', '../../html/directives/buttons_order.html'], function (angular, template)
{
	var moduleName = 'cla.buttons.buttons_order';
	var module;
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, ['cla.buttons.options.service', 'ui.sortable']);
	}

	module.directive('claButtonsOrder', ['$timeout', 'buttonsOptionsService', buttonsOrder]);

	function buttonsOrder($timeout, service)
	{
		var controller = function($timeout)
		{
			var ctrl = this;

            this.$onInit = function() {
                ctrl.dragOptions = {
                    orderChanged: function () {
                        ctrl.syncOrder();
                    },
                    containment: '#drag-list-' + ctrl.id,
                    appendTo: '#drag-list-' + ctrl.id,
                    containerPositioning: 'relative'
                };

                for (var i = 0; i < ctrl.ngModel.length; i++)
                {
                    service.addButtonOrder(ctrl.ngModel[i]);
                }
            };

			ctrl.order = service.buttons_order;
			ctrl.order.length = 0;
			ctrl.listId = 'list';
			ctrl.dragOptions = {};
            ctrl.areAnyHidden = false;

			ctrl.syncOrder = function()
			{
				ctrl.ngModel.length = 0;
				for (var i = 0; i < ctrl.order.length; i++)
				{
					ctrl.ngModel.push(ctrl.order[i]);
				}

                ctrl.areAnyHidden = service.areAnySelectedButtonsHidden();
			};

			//callback function to service
			service.register_callback(ctrl.syncOrder);

			$timeout(function () {
				service.compareButtonDataAndOrder();
			}, 0);
		};

		return {
			controller: controller,
			bindToController: true,
			controllerAs: 'ctrl',
			restrict: 'E',
			require: '^ngModel',
			templateUrl: template,
			scope: {
				ngModel: '=',
				id: '@'
			}
		};
	}
});
