define(['cla_angular', '../../html/directives/no_results.html'], function (angular, template)
{
	var moduleName = 'cla.buttons.manage';
	var module;
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, []);
	}

	module.directive('noResults', noResults);

	noResults.$inject = ['buttonsService'];
	function noResults(service)
	{
		var controller = function()
		{
			var ctrl = this;

			ctrl.getFilterText = function()
			{
				return service.filterTerm;
			};
		};

		return {
			controller: controller,
			bindToController: true,
			controllerAs: 'ctrl',
			restrict: 'E',
			require: '^ngModel',
			templateUrl: template,
			scope: {}
		};
	}
});