<?php
$_db_migration_to = '01.01'; // 1.0.0-beta
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_initial setup.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$desc =[
	"id" => "IDENTITY",
	"title" => "VARCHAR(100) DEFAULT NULL",
	"url" => "VARCHAR(255) DEFAULT NULL",
	"open_in_new_tab" => "BOOL DEFAULT 0",
	"icon" => "VARCHAR(25) DEFAULT NULL",
	"background_colour" => "VARCHAR(6) DEFAULT NULL",
	"icon_colour" => "VARCHAR(6) DEFAULT NULL",
	"tooltip" => "VARCHAR(100) DEFAULT NULL"
];
$db->CreateTable('button', $desc);
DB_UPDATE_FILE
);


$migrations->Run('02_creation_details.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('button', "created_by", "INT");
$db->AddColumn('button', "created_date", "INT_DATE");

DB_UPDATE_FILE
);


$migrations->Run('03_update_details.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('button', "updated_by", "INT");
$db->AddColumn('button', "updated_date", "INT_DATE");

DB_UPDATE_FILE
);


$migrations->Run('04_image_column.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('button', "image", "INT DEFAULT 0");

$data_dir = $migrations->GetDataDir();
if (!is_dir("$data_dir/buttons"))
{
	mkdir("$data_dir/buttons", 0777);
	chmod("$data_dir/buttons", 0777);
}
DB_UPDATE_FILE
);


$migrations->Run('05_image_column.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AlterColumn('button', "image", "image", "BOOL DEFAULT 0");

list($ids) = $db->query_row('SELECT id FROM button WHERE image > 0');
if (count($ids) > 0)
{
	$db->unsafe_query = true;
	$db->query('UPDATE button SET image = 1 WHERE id in in:int:ids', $ids);
}
DB_UPDATE_FILE
);


$migrations->Run('06_admin_panel_and_manage_perms.php', <<<'DB_UPDATE_FILE'
<?php

use Claromentis\Buttons\Permissions;

/** @var \Claromentis\Setup\SetupFacade $migrations */
$admin_panel = $migrations->GetAdminPanelCreator();
$admin_panel->Enable('buttons');

$db = $migrations->GetDb();

// Allow admin to edit buttons
$db->query("INSERT INTO permissions (class_id, object_id, perm_owner_class_id, perm_owner_id, rights) VALUES
 (int:class, int:site_id, int:oclass, 1, int:rights)",
	143, 1, 1, 1);
DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('01.01');
