/**
 * Utility class to handle button layout changing as the component and/or browser changes
 *
 * @param {string} targetId
 */
function ButtonsInit(targetId) {
	var target = $('.js-tile[data-tile-id="' + targetId + '"]');

	/**
	* Show a warning message if the component isn't tall enough
	*/
	function checkHeight() {
		if (target.find('.drag-overlay').length === 0)
			return;

		var listHeight =  target.find('.button-wrapper').prop('scrollHeight');
		var wrapperHeight = target.find('.js-tile-body').innerHeight();

		if (listHeight - 10 > wrapperHeight) {
			$('.space-message').remove();
			target.find('.js-tile-body-container').append('<span class="space-message bg-warning">' + lmsg('buttons.component.warning.not_enough_room') + '</span>');
		} else {
			target.find('.space-message').remove();
		}
	}
    /**
     * Truncate Long Button Titles
     */
	function truncateLongButtonTitle() {
		target.find('.button-text').removeClass('truncate-text');

		target.find('.button').each(function(){
            $.fn.textWidth = function() {
                return($.textWidth(this.html()));
            }
            $.textWidth = function(text) {
                var div = $('#textWidth');
                if (div.length == 0)
                    div = $('<div id="textWidth" style="display: none;"></div>').appendTo($('body'));
                div.html(text);
                return(div.width());
            }

			var button = $(this);

			var buttonHeight = button.innerHeight() + 5;
			var buttonInnerHeight = button.find('.button-inner').innerHeight();
			var buttonWidth = button.innerWidth();
			var buttonInnerWidth = button.find('.button-text').textWidth();
			var buttonText = button.find('.button-text');

			if (buttonHeight < buttonInnerHeight ||  buttonWidth < buttonInnerWidth) {
				buttonText.addClass('truncate-text');
			}
		})
	}

	/**
	* Resize glyphicons to fit the button if set to icon-only
	*/
	function flexicons() {
		$(".large-link").each(function() {
			if ($(this).outerHeight() < $(this).outerWidth()) {
				var relativeHeight =	$(this).outerHeight()*0.65;
				$(this).children('.bg-image-large').children(".glyphicons").css("font-size", relativeHeight);
			} else {
				var relativeWidth =	$(this).outerWidth()*0.65;
				$(this).children('.bg-image-large').children(".glyphicons").css("font-size", relativeWidth);
			}
		});
		$(".small-link").each(function() {
		    var glyph = $(this).find(".glyphicons");

            if (window.innerWidth < 992) {
                return glyph.css("font-size", 40);
            }else if ($(this).outerHeight() < $(this).outerWidth()) {
				var relativeHeight =	$(this).outerHeight()*0.45;
                relativeHeight > 40 ? glyph.css("font-size", relativeHeight) : null;
			} else {
				var relativeWidth =	$(this).outerWidth()*0.45;
                relativeWidth > 40 ? glyph.css("font-size", relativeWidth) : null;
			}
		});
	}

	function imgResize() {
        //Small Link buttons resize
            $(".small-link").each(function() {
                    var imgWrapper = $(this).find(".img-wrapper");
                    var relativeHeight =	$(this).outerHeight()*0.45;
                    if (window.innerWidth < 992) {
                        return imgWrapper.css("height", 40);
                    }
                    relativeHeight > 40 ? imgWrapper.css("height", relativeHeight) : null;
            });

        // Make sure background images don't scale beyond their true size
        $("div[class*='bg-image-\']").each(function() {
            if ($(this).css('background-size') == 'contain') {
                var img = new Image;
                var currObj = $(this);
                img.src = currObj.css('background-image').replace(/url\(|\)$/ig, "").replace(/"/g, "").replace(/'/g, "");
                img.onload = function(){
                    if (img.width < currObj.width() && img.height < currObj.height()) {
                        currObj.css('background-size', 'auto auto');
                    }
                }
            }
        });
    }

    //Position button text halfway between bottom of the icon/image and the bottom of the button
    function positionButtonText() {
		$(".small-link").each(function() {
			if($(this).has('.img-wrapper + .button-text').length === 1) {
				var gap = ($(this).outerHeight() - $(this).find('.img-wrapper').outerHeight()) - $(this).find('.button-text').outerHeight();
				var textPosition = ((gap / 2) / 2 - 5);
				var relativeHeight = $(this).outerHeight() * 0.45;
                if (window.innerWidth < 992) {
                    return $(this).find('.button-text').css('margin-top', 5);
                }
                relativeHeight > 45 ? $(this).find('.button-text').css('margin-top', textPosition) : null;
			}
		})
	}

    //Add custom class to tooltip in order to add styling
    target.find('.button').tooltip({
        'customClass': 'button-tooltip'
    })

    //
	function checkSize() {
		checkHeight();
		flexicons();
        imgResize();
		truncateLongButtonTitle();
		positionButtonText();
		if (GetIEVersion() > 0 ) {
			require(['/intranet/buttons/js/buttons-ie-only.js'], function(){
				layoutButtonsIe(target);
			});
		}
	}

	$(window).on('resize', checkSize);
	target.on('pages-tile-resize pages-tile-add', checkSize);
	checkSize();

	function GetIEVersion() {
		var sAgent = window.navigator.userAgent;
		var Idx = sAgent.indexOf("MSIE");

		// If IE, return version number.
		if (Idx > 0)
		return parseInt(sAgent.substring(Idx+ 5, sAgent.indexOf(".", Idx)));

		// If IE 11 then look for Updated user agent string.
		else if (!!navigator.userAgent.match(/Trident\/7\./))
		return 11;

		else
		return 0; //It is not IE
	};



}
