define(['cla_angular', '../../html/directives/buttons_button.html'], function (angular, template)
{
	var moduleName = 'cla.buttons.manage';
	var module;
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, []);
	}

	module.directive('buttonsButton', buttonsButton);

	buttonsButton.$inject = ['buttonsService'];
	function buttonsButton(service)
	{
		var controller = function()
		{
			var ctrl = this;

            this.$onInit = function() {
                ctrl.button = service.getButton(ctrl.buttonId);
            };

			ctrl.serviceStatus = service.getStatus();

			ctrl.onSelect = function(event)
			{
				event.preventDefault();

				// Bail out if we were already selected
				if (ctrl.serviceStatus.selectedId === ctrl.button.id)
					return;


				ctrl.serviceStatus.selectedId = ctrl.button.id;

				service.select(ctrl.serviceStatus.selectedId);
			};

			ctrl.onDelete = function(event)
			{
				event.preventDefault();
				event.stopPropagation();

				if (confirm(lmsg('buttons.confirm_delete')))
					service.deleteButton(ctrl.button);
			};

			ctrl.onDuplicate = function(event)
			{
				event.preventDefault();
				event.stopPropagation();

				service.cloneButton(ctrl.button);
			};

			ctrl.imageUrl = function()
			{
				if (ctrl.button.image.new_url === '')
					return ctrl.button.image.url;
				else
					return ctrl.button.image.new_url;
			};
		};

		return {
			controller: controller,
			bindToController: true,
			controllerAs: 'button',
			restrict: 'E',
			templateUrl: template,
			scope: {
				buttonId: '='
			}
		};
	}
});
