	define(['cla_angular', '../../html/directives/buttons_button_edit.html', '../../../js/kolorpicker/jquery.kolorpicker.js', '../../../js/kolorpicker/style/kolorpicker.css'], function (angular, template)
{
	var moduleName = 'cla.buttons.manage';
	var module;
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, []);
	}

	module.directive('buttonsButtonEdit', buttonsButtonEdit);

	buttonsButtonEdit.$inject = ['$rootScope', '$timeout', 'buttonsService', 'buttonEditorService'];
	function buttonsButtonEdit($rootScope, $timeout, service, editorService)
	{
		var controller = function()
		{
			var ctrl = this;

			ctrl.permsControl = {};
			ctrl.tagsControl = {};
			ctrl.imageControl = {};
			ctrl.iconColourControl = {};
			ctrl.backgroundColourControl = {};

			ctrl.saveDisabled = true;

			ctrl.serviceStatus = service.getStatus();

			ctrl.button = {
				id: 0,
				title: '',
				url: '',
				icon: '',
				image: {
					id: 0,
					url: ''
				},
				open_in_new_tab: true,
				icon_colour: '',
				background_colour: '',
				tooltip: '',
				perms: {owners: []},
				tags: ''
			};
			ctrl.suggestedTags = editorService.getSuggestedTags();

			ctrl.callback = function(button)
			{
				ctrl.saveDisabled = false;

				ctrl.button.type = button.type;
				ctrl.button.id = button.id;
				ctrl.button.title = button.title;
				ctrl.button.url = button.url;
				ctrl.button.icon = button.icon;
				ctrl.button.image.id = button.image.id;
				ctrl.button.image.url = button.image.url;
				ctrl.button.image.new_image = button.image.new_image;
				ctrl.button.image.new_url = button.image.new_url;
				ctrl.button.open_in_new_tab = button.open_in_new_tab;
				ctrl.button.icon_colour = '#' + button.icon_colour;
				ctrl.button.background_colour = '#' + button.background_colour;
				ctrl.button.tooltip = button.tooltip;
				ctrl.button.showTooltip = button.tooltip !== '';
				ctrl.button.perms = button.perms;
				ctrl.button.tags = button.tags.join(', ');

				// Always show at least the default icon if nothing else is set
				if ((ctrl.button.icon === '') &&
					(ctrl.button.image.id === 0))
				{
					ctrl.button.icon = 'file';
				}

				// The request may have come from another ng application so trigger a digest to re-render
				$timeout(function()
				{
					$rootScope.$digest();

					if ((ctrl.permsControl !== undefined) &&
						(ctrl.permsControl.populate !== undefined))
					{
						ctrl.permsControl.populate();
					}

					if ((ctrl.tagsControl !== undefined) &&
						(ctrl.tagsControl.reset !== undefined))
					{
						ctrl.tagsControl.reset();
					}

					if ((ctrl.imageControl !== undefined) &&
						(ctrl.imageControl.reset !== undefined))
					{
						ctrl.imageControl.reset();
					}

					if ((ctrl.iconColourControl !== undefined) &&
						(ctrl.iconColourControl.reset !== undefined))
					{
						ctrl.iconColourControl.reset();
					}

					if ((ctrl.backgroundColourControl !== undefined) &&
						(ctrl.backgroundColourControl.reset !== undefined))
					{
						ctrl.backgroundColourControl.reset();
					}
				}, 0);
			};
			ctrl.enableCallback = function()
			{
				ctrl.saveDisabled = false;
			};
			service.registerEditCallback(ctrl.callback, ctrl.enableCallback);

			ctrl.save = function($event)
			{
				$event.preventDefault();

				ctrl.saveDisabled = true;

				ctrl.permsControl.sync();
				service.saveButton(ctrl.button);
			};

			ctrl.cancel = function($event)
			{
				$event.preventDefault();

				ctrl.saveDisabled = false;

				service.unselect();
			};
		};

		return {
			controller: controller,
			bindToController: true,
			controllerAs: 'edit',
			restrict: 'E',
			templateUrl: template,
			scope: {}
		};
	}
});
