define(['cla_angular'], function (angular)
{
	var moduleName = 'cla.buttons.manage';
	var module;
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, ['preloadModule']);
	}

	module.directive('claButtonsPreload', buttonsPreload);

	buttonsPreload.$inject = ['buttonsService', 'buttonEditorService', 'preloadFactory'];
	function buttonsPreload(service, editorService, dataFactory)
	{
		var link = function(scope, element, attributes, ctrl)
		{
			service.init(dataFactory.buttonsData);
			editorService.init(dataFactory.suggestedTags);
		};

		return {
			link: link,
			restrict: 'E',
			template: '',
			scope: {}
		};
	}
});