define(['cla_angular', '../../html/directives/buttons_search.html'], function (angular, template)
{
	var moduleName = 'cla.buttons.manage';
	var module;
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, []);
	}

	module.directive('buttonsSearch', buttonsSearch);

	buttonsSearch.$inject = ['buttonsService'];
	function buttonsSearch(service)
	{
		var controller = function()
		{
			var ctrl = this;

			ctrl.term = '';

			ctrl.onChange = function()
			{
				service.filter(ctrl.term);
			};
		};

		return {
			controller: controller,
			bindToController: true,
			controllerAs: 'ctrl',
			restrict: 'E',
			templateUrl: template,
			scope: {}
		};
	}
});
