define(['cla_angular', '../../html/directives/buttons_select.html'], function (angular, template)
{
	var moduleName = 'cla.buttons.buttons_select';
	var module;
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, ['cla.buttons.options.service']);
	}

	module.filter("decodeSpecialChars", [decodeFilter]);
	module.directive('claButtonsSelect', ['buttonsOptionsService', buttonsSelect]);

	function decodeFilter()
	{
		function decodeHtml(html) {
			var txt;

			if (typeof(html) === 'object')
			{
				for (var key in html)
				{
					if (html.hasOwnProperty(key))
					{
						txt = document.createElement("textarea");
						txt.innerHTML = html[key];
						html[key] = txt.value;
					}
				}

				return html;
			}

			txt = document.createElement("textarea");
			txt.innerHTML = html;
			return txt.value;
		}

		return function(encoded)
		{
			return decodeHtml(encoded);
		}
	}

	function buttonsSelect(service)
	{
		var controller = function()
		{
			var ctrl = this;

            this.$onInit = function () {
                if (ctrl.options && ctrl.options.buttons) {
                    for (var i = 0; i < ctrl.options.buttons.length; i++) {
                        if (ctrl.options.buttons[i].isSelected) {
                            service.addButtonData(ctrl.options.buttons[i]);
                        }
                    }
                }
            };

			ctrl.uid = Math.random();

			ctrl.buttonToggled = function(option)
			{
				if (option.isSelected)
				{
					ctrl.ngModel.push(option.id);
					service.addButton(option);
				} else
				{
					var index = ctrl.ngModel.indexOf(option.id);
					if (index > -1)
						ctrl.ngModel.splice(index, 1);

					service.removeButton(option);
				}
			};
		};

		return {
			controller: controller,
			bindToController: true,
			controllerAs: 'ctrl',
			restrict: 'E',
			require: '^ngModel',
			templateUrl: template,
			scope: {
				ngModel: '=',
				options: '='
			}
		};
	}
});
