# Releases

Claromentis releases contain specific versions of Claromentis Core and Modules.

Releases are GitLab CI build artifacts that contain:

- `application` directory containing all application code
- `.env.example` file containing environment variable configuration
- `composer.json` file describing version constraints for Claromentis Core and Modules
- `composer.lock` file describing locked package versions of Claromentis Core, Modules and their dependencies
- [Docker images](docker.md) that contain all of the above, served over port 80 by Nginx and PHP-FPM

## Release process

The following steps should be followed to release a new version of Claromentis.

1. Ensure that the appropriate version branch is checked out, such as `8.13`, `9`, or `10`
2. Ensure that `composer.json` requires Claromentis Core (`claromentis/framework`) and Modules at the appropriate
   [version constraints](composer.md)
   - **Example:** For the `8.13` branch, the Core requirement should be `"claromentis/framework": "8.13.x@dev"`
   - **Example:** For the `10` branch, the Core requirement should be `"claromentis/framework": "^10@dev"`
3. Update the [change log](../CHANGELOG.md) as needed
4. Run `composer update --prefer-stable` using Composer 2 to update dependencies to the latest and most stable versions
5. Run `composer diff --format mdlist --with-links` and copy the Markdown for all `claromentis/*` packages to a new
   version in the [change log](../CHANGELOG.md)
6. Run `git add . && git commit -m "Released <version>" && git tag <version> && git push && git push origin <version>`
   to commit, tag and push the resulting changes as a new release using Git
