# Claromentis 9 Upgrade Guide

**Claromentis 9** is the first new major version of the product since 2016. Despite this, the development team have
tried to keep backwards-incompatible changes to a minimum and keep the upgrade process as simple as possible.

This guide provides the process for manually upgrading a **Claromentis 8.13** system to **Claromentis 9**.<br/>
It is written for **Support Technicians** that perform manual Claromentis upgrades on client systems.

- [Assumptions](#assumptions)
- [Preparation](#preparation)
- [Upgrading](#upgrading)
  - [Custom distributions](#custom-distributions)
- [Motivation](#motivation)

## Assumptions

This guide currently makes the following assumptions, for the sake of simplifying examples, that
**you may have to adapt** for the system that you're upgrading:

- Claromentis 8.x is installed on a Linux system at `/Claromentis/application`
- Correct ownership for all files is `apache:claroteam`
- The web server uses `/Claromentis/application/web` as the document root, and `/Claromentis/application/web/index.php`
  as front-controller fallback for requested paths that are not found
- The **user** you are running as has **full permissions** to read, write and delete everything in `/Claromentis`
  - Your user's primary group should be `claroteam`, or whichever group shares read-write permissions with Apache/PHP
  - You **will encounter permission errors** if you run the below verbatim without setting permissions properly

## Preparation

Preparation steps are necessary to ensure a smooth upgrade process and easy rollbacks in case of errors.

### 1. Disable user access

**Disable user access** to the Claromentis system.

This can be achieved using Apache redirects, or any other means. The main purpose is to prevent users from changing any
system state during the upgrade, which could cause fatal errors during migrations.

### 2. Upgrade to the latest Claromentis 8.13 release

**Upgrade** to the **latest Claromentis Core 8.13.x** release, and uninstall the `chat` and `social` modules.

1. **Uninstall the `chat` and `social` modules** and remove their codebases
   - Run `./clc app:uninstall chat social && rm -rf web/intranet/chat web/intranet/social`
2. Follow this guide in its entirety, but when [upgrading](#upgrading), find the `composer.json` and `composer.lock`
   files for the latest available Claromentis 8.13.x release
3. Follow this guide again to upgrade to Claromentis 9 or 10

### 3. Create a full backup

Create a **full backup** of the application, data volume, and database, in case a rollback is needed later.

- **Application:** `/Claromentis/application`
- **Data volume:** `/Claromentis/data`
- **Database:** MySQL or SQL Server dump of the `claromentis` database

### 4. Ensure a stateless application directory

A **stateless application directory** contains no configuration, user data, or any other **state**. This makes it much
easier to update the application, by deleting and replacing its entire codebase safely.

1. **Extract Core configuration** from `/Claromentis/application/web/intranet/common/config.php`
   - Environment configuration belongs in `/Claromentis/.env` or real environment variables
   - Product configuration and preferences belong in `/Claromentis/data/config/core.json` by using the
     [Configuration Editor](https://docs.claromentis.net/#/product/core/docs/technical/configuration/?id=configuration-editor)
     at **Admin > System > Configuration > Core**
   - See [Configuration](https://docs.claromentis.net/#/product/core/docs/technical/configuration/) for more
     information
2. **Extract module configuration** if needed, following the same steps as above
   1. Core modules: `/Claromentis/application/web/intranet/<module>/config_<module>.php`
   2. Custom modules: `/Claromentis/application/web/custom/<module>/config_<module>.php`
3. Ensure that the **data volume** is situated at `/Claromentis/data`, and **not inside the Core application**
   directory of `/Claromentis/application/data`
   - If you need to move the data volume from `/Claromentis/application/data` to `/Claromentis/data`, make sure you
     also set the `CLARO_DATA_DIR` environment variable to `/Claromentis/data`
   - `/Claromentis/data` is usually the default data volume path, so you will likely be able to skip this step

### 5. Ensure that filesystem permissions are correct

1. Set ownership: `sudo chown -R apache:claroteam /Claromentis`
2. Set permissions: `sudo chmod -R ug+rwX,o+r,o-wx /Claromentis`

### 6. Upgrade from Composer 1 to Composer 2

- Visit https://getcomposer.org/download/ to install a new Composer binary
- Run `sudo composer self-update --2` to upgrade an existing Composer binary

## Upgrading

The installation and upgrade process has changed in Claromentis 9. This includes running `composer install` from
`/Claromentis` instead of running `composer update` from `/Claromentis/application/installer`.

See [Motivation](#motivation) for a summary of the changes to the process and the motivations behind them.

1. **Find the `composer.json` and `composer.lock` files** for the Claromentis release that you want to install
   1. Navigate to https://packages.claromentis.net/#claromentis/claromentis
   2. Download the release package for your desired Claromentis version by clicking on a stable version number
   3. Extract `composer.json` and `composer.lock` from the archive
2. **Copy `composer.json` and `composer.lock`** to `/Claromentis/composer.json` and `/Claromentis/composer.lock` on the
   server
3. **Install the codebase**
   - Run `composer install --prefer-dist --no-dev --optimize-autoloader` from `/Claromentis` as an appropriate user
4. **Run migration scripts:**
   - Run `./clc app:upgrade --all` from `/Claromentis/application`
5. **Restore user access** to the Claromentis system

If you encounter any errors, please report them to the Product team.

### Custom distributions

Custom modules are available via custom Claromentis distributions, called [Claromentis distros](https://gitlab.com/claromentis/product/distros)
for short.

These are full Claromentis installations that are prepared in advance by developers, much like the Claromentis project.
This allows for the same deterministic codebase to be installed at deployment time, but with the inclusion of custom
Claromentis modules.

The simplest installation method for Claromentis distributions is summarised by the [**offline installation guide**](installation/offline.md).

Alternatively, follow the steps below to install using [Composer](https://getcomposer.org) and [Git](https://git-scm.com).

1. [Install Git](https://git-scm.com/book/en/v2/Getting-Started-Installing-Git) and configure a [GitLab access token](gitlab-authentication.md#access-tokens)
   so that Composer can use Git to download custom modules from GitLab.com
2. Ask the **development team** which distribution you should use if you are not sure
   - Use `vanilla-loginhandler` for systems using Login Handler, User Sync, and no other custom modules
   - Use `client-<client-name>` for client-specific distributions
   - Use `internal-<system-name>` for internal Claromentis systems
3. **Find the `composer.json` and `composer.lock` files** for the Claromentis distribution release that you want to install
   1. Navigate to the [Claromentis Distros package registry](https://gitlab.com/claromentis/product/distros/-/packages)
   2. Search for the distribution that you want to install
      - Client distributions are prefixed with `client-*`
      - Internal distributions are prefixed with `internal-*`
   3. Select the package archive, ensuring that you've chosen the correct version
   4. Download the package archive (`.zip` file)
   5. Extract `composer.json` and `composer.lock` from the archive
4. Continue from **step 2** of the [**upgrade guide**](#upgrading)

## Motivation

There were several problems with the installation process for Claromentis 8.

- **Non-deterministic installations**
  - Depending on when you run the `composer update` command, you may end up with different versions of Core & Modules
    based on what has been released
  - This results in a fragmentation of Claromentis Core & Module versions across client systems, increasing the
    likelihood of bugs that are difficult to reproduce on other systems
- **Dirty upgrades**
  - The Claromentis 8 upgrade process copies new versions of Claromentis Core _on top of the existing installation_
    - This leads to old files not being deleted properly if they are missed by cleanup migrations, and can cause
      bugs
    - The main reason for this was to retain **stateful file paths**, such as `config.php` and `web/appdata`, which
      were mixed into the file structure of the **application codebase**
  - `modules.json` is maintained on client servers only, and not anywhere else, meaning we have to connect to client
    servers to determine what's installed
  - Custom modules and their Composer dependencies are installed separately to Claromentis Core & Modules, which can
    cause site-breaking dependency conflicts and contribute to further variance across deployments that we have
    to track (or rediscover) manually
- **Dependency bundling**
  - Claromentis Core distributions abuse Composer's behaviour by bundling fixed dependencies, which complicates our
    [build system](https://gitlab.com/claromentis/product/services/satisfactory) and our
    [Composer Installer Plugin](https://gitlab.com/claromentis/product/composer-installer)
  - Core dependencies and modules are installed differently between development and production system across two
    separate directories (`vendor` and `vendor_core`), resulting in some bugs that are difficult to reproduce, and
    difficulty installing module dependencies on development systems
- **Performance**
  - Composer 1 consumes a lot of memory, and downloads and installs each package one-by-one
  - Additionally, Composer 1 was officially deprecated in 2021

The installation process for Claromentis 9 has been improved considerably. It is simpler, faster, and more predictable.

- `/Claromentis/application/installer` has been removed and the
  [Claromentis project](https://gitlab.com/claromentis/product/claromentis) has been introduced
  - Powered by **[Composer Installer Plugin 2](https://gitlab.com/claromentis/product/composer-installer)** and
    Composer 2
  - Supports **Composer 2** for asynchronous downloads and installation, lower memory consumption
- Previously, we would run `composer update -d installer --prefer-dist --no-dev` from `/Claromentis/application`
  - This would merge `/Claromentis/application/installer/composer.json` and `/Claromentis/application/modules.json`
    and result in non-deterministic, dirty upgrades
  - Installs over itself in `/Claromentis/application`
- Moving forward, we will run `composer install --prefer-dist --no-dev` from `/Claromentis`
  - This uses a new `/Claromentis/composer.lock` that specifies _**exact**_ dependencies for deterministic
    installations
  - Installs into `/Claromentis/application` as a subdirectory
  - Retains known stateful file paths if there are any, performs faster when there aren't any
  - If there are no stateful files in `/Claromentis/application`, it's safe to `rm -rf /Claromentis/application` and
    reinstall the codebase with `composer install`
  - Installations that use custom modules will require their own `composer.json` and `composer.lock` files, meaning
    that we control system variation from a Git repository rather than a single file on a server
