# Development

Claromentis software development is distributed across several software projects: Core & Modules.

The [Claromentis](https://gitlab.com/claromentis/product/claromentis) project brings Claromentis Core & Modules together
using the [Composer](https://getcomposer.org) package manager, and prepares builds for development, QA and release using
GitLab CI/CD and Docker.

If you would like to coordinate development and QA for a Claromentis change that involves one or more development
branches across Core and/or modules, see [Create a Claromentis branch](#create-a-claromentis-branch).

If you would like to add custom modules to Claromentis, see the
[Distros](https://gitlab.com/claromentis/product/distros) project.

## Create a Claromentis branch

To coordinate development and testing of Claromentis changes that affect the installation process, or multiple
Claromentis projects, such as Core and multiple modules, then creating a new Claromentis branch is a helpful way to
test this easily.

With the above, set up, you can then run the following to [test with Docker](#test-with-docker).

### Prerequisites

You'll need to have at least one development branch of Core or a module to follow this guide.

For this example, we'll assume that you've already made some changes to Core and the Pages module.

- Example [**Claromentis Core**](https://gitlab.com/claromentis/product/core) branch:
  - `feature/acme_CLARO-123`, branched from the `v9` Claromentis Core branch
- Example [**Pages**](https://gitlab.com/claromentis/product/pages) branch:
  - `feature/acme-pages_CLARO-123`, branched from the `v2.1` Pages branch

### Create a new Claromentis branch using Git

Using your command-line terminal, or Git GUI of choice, create a new Claromentis branch from the appropriate version
branch, after making sure it's up to date locally.

For this example, we'll branch from `9`.

```shell
cd ~/workspace/claro9
git checkout 9
git pull -pr
git checkout -b feature/acme_CLARO-123
git push -u origin feature/acme_CLARO-123
```

### Update Composer dependencies

Edit `composer.json` to specify the version requirements of Core & Modules for your change.

For this example, we'll update `claromentis/framework` (Core) and `claromentis/pages` (Pages) in the `require` section
of the `composer.json` file.

| Project                  | Example branch or tag                                   | Composer version constraint                     |
|--------------------------|---------------------------------------------------------|-------------------------------------------------|
| Claromentis Core branch  | `feature/acme-core_CLARO-123`<br/>branched from `v9`    | `dev-feature/acme-core_CLARO-123 as 9.x-dev`    |
| Pages branch             | `feature/acme-pages_CLARO-123`<br/>branched from `v2.1` | `dev-feature/acme-pages_CLARO-123 as 2.1.x-dev` |

```json
{
  "require": {
    "claromentis/framework": "dev-feature/acme-core_CLARO-123 as 9.x-dev",
    "claromentis/pages": "dev-feature/acme-pages_CLARO-123 as 2.1.x-dev",
    "...": "..."
  }
}
```

> **Note:**
> 
> **Don't use the `@dev` suffix** when specifying a development branch with an alias. This is already implied to
> Composer by the **`dev-` prefix**, which indicates that it's a development branch (`feature/*`, `improvement/*`,
> `bugfix/*`) instead of a version branch (`8.13`, `9`).

Then, run Composer's update command to update the locked dependencies in `composer.lock`

```shell
composer update
```

> **Note:**
> 
> **Don't use the `--ignore-platform-reqs` command-line option** with `composer update`. This will cause Composer to
> ignore our PHP version constraints, and update our dependencies to versions that aren't compatible.

Finally, commit your changes to your new branch.

```shell
git add .
git commit -m "CLARO-123 Updated Claromentis dependencies for the new Acme feature"
git push
```

The Claromentis CI/CD pipeline will build your new version of Claromentis, which should take around ten minutes.

### Test with Docker

You can test your new version of Claromentis in a self-contained Docker container using SQLite. This is particularly
useful when you need to test behaviour for fresh installations of Claromentis.

First make sure that the CI/CD pipeline succeeded for your commit from the previous step.

For this example, we'll use the `feature-acme_CORE-123-dev` Docker tag, which is derived from our example branch name,
`feature/acme_CORE-123`.

```shell
docker run -it --rm -p 80:80 --pull always \
--env CLARO_DB_TYPE=sqlite \
--env CLARO_ADMIN_PASSWORD=claromentis \
--env CLARO_FF_SEED=1 \
registry.gitlab.com/claromentis/product/claromentis:feature-acme_CORE-123-dev
```

> **Note:**
> 
> If you don't want the [Seed module](https://gitlab.com/claromentis/product/modules/seed) to run, you can remove the
> `--env CLARO_FF_SEED=1` command-line option.

Below are some example conversions of Claromentis branch names to Docker tags. See the
[Docker documentation](./docker.md) for more information.

| Claromentis branch                             | Production Docker tag    | Development Docker tag       |
|------------------------------------------------|--------------------------|------------------------------|
| `8.13`                                         | `8.13-edge`              | `8.13-edge-dev`              |
| `9`                                            | `9-edge`                 | `9-edge-dev`                 |
| `feature/acme_CLARO-123`<br/>branched from `9` | `feature-acme_CLARO-123` | `feature-acme_CLARO-123-dev` |
