# Offline installations

Offline installations of Claromentis can be required when target systems have strict security practices that limit the
software we can use for an installation or limit our access to external systems.

For nearly all of our installation methods, installing the Claromentis codebase can be made more "offline" by using the
pre-built packages instead of Composer. These packages are built with every Claromentis or Claromentis distro release.

## Install Claromentis from a package

Installing the Claromentis codebase without Composer or Git can be summarised like so:

1. Find the package of the Claromentis release that you want to install
   - Use [Claromentis packages](https://gitlab.com/claromentis/product/claromentis/-/packages) for standard installations
   - Use [Claromentis distro packages](https://gitlab.com/claromentis/product/distros/-/packages) for custom distro installations
2. Download the package and transfer it to the server
3. When upgrading from Claromentis 8.13 to Claromentis 9, follow the [preparation steps](../9.0-upgrade.md#preparation)
4. Delete `/Claromentis/application`, `/Claromentis/composer.json` and `/Claromentis/composer.lock`
5. Extract the new codebase from the package archive into `/Claromentis`
6. Run migrations scripts using `./clc app:upgrade --all`

This guide is a **summary**, and does not cover everything necessary for a Claromentis installation. See the [other
installation guides](README.md) for more information.
