# Claromentis Change Log

## Unreleased

- !6 CI pipeline improvements
  - FRAM-31 FRAM-728 Implemented publishing Claromentis distributions to the GitLab Package Registry as Generic Packages
  - FRAM-14 FRAM-728 Implemented GitLab releases
  - Refactored computed CI variables to a single job using dotenv artifacts
  - Improved cache hits for CI jobs by using a fallback cache key, and `composer.lock` as an alternative cache key
- !7 FRAM-838 Added Seed module 3.0

## 9.0.0-rc3 - 5th August 2022

- FRAM-594 Improved automated healthcheck tests
- Core 9.0.0-rc3 -> 9.0.0-rc4
- All modules updated

## 9.0.0-rc2 - 22nd July 2022

- Core 9.0.0-rc2 -> 9.0.0-rc3
- Badges 2.0.0 -> 2.0.1
- DMSV 3.0.0 -> 3.0.1
- IC Dashboard 4.0.0 -> 4.0.1
- Pages 2.0.1 -> 2.1.0
- People Component 3.0.0 -> 3.0.1
- CI pipeline improvements
  - Separated production and development Docker image release jobs
  - Updated production release job to push Docker images to Google Container Registry

## 9.0.0-rc - 30th June 2022

- Core 9.0.0-rc2
- All modules stable
- Development Docker image builds
- CI jobs for automated tests:
  - Core installation for production and development images
  - Core unit tests
  - PHP compatibility across the entire codebase
  - Healthcheck via CLC and REST API

## 9.0.0-beta4 - 29th April 2022

- Core 9.0.0-beta6
- Quiz 3.0.0-beta2
- Reports 2.0.0-beta2
- Included `composer.json` and `composer.lock` in Docker image builds

## 9.0.0-beta3 - 27th April 2022

- claromentis/announcements (2.0.0-beta => 2.0.0)
- claromentis/badges (2.0.0-beta => 2.0.0)
- claromentis/buttons (2.0.0-beta => 2.0.0)
- claromentis/discuss (2.0.0-beta => 2.0.0)
- claromentis/framework (9.0.0-beta4 => 9.0.0-beta5)
- claromentis/hr (2.0.0-beta => 2.0.0)
- claromentis/lms (3.0.0-beta2 => 3.0.0)
- claromentis/pages (2.0.0-beta => 2.0.0)
- claromentis/projects (3.0.0-beta => 3.0.0-beta2)
- claromentis/weather (5.0.0-beta => 5.0.0)


## 9.0.0-beta2 - 11th April 2022

- Claromentis Core updated to 9.0.0-beta4
  - Added Behat development dependencies
  - Removed `twbs/bootstrap-sass` dependency
- Composer Installer Plugin 2.0.0 stable
- Slider 6.0.0 stable
- LMS 3.0.0-beta2
- People Component 3.0.0-beta2
- Improved installation guides and documentation

## 9.0.0-beta - 18th March 2022

- Claromentis Core updated to 9.0.0-beta3
- Modules updated to beta, except Slider which is at alpha
- Added PhpStorm configuration for PHP code style and VCS directory mappings
- Updated the way `wkhtmltopdf` is installed for Docker images

## 9.0.0-alpha4 - 24th November 2021

- claromentis/framework@9.0.0-alpha4
- All modules @dev-feature/9.0 except for Tasks

## 9.0.0-alpha3 - 12th November 2021

- claromentis/framework@9.0.0-alpha3
- All modules @dev-feature/9.0 except for Discuss and Tasks

## 9.0.0-alpha2 - 24th May 2021

- claromentis/framework@9.0.0-alpha2
- claromentis/knowledgebase@dev-feature/ui-refresh beb541f
- claromentis/pages@dev-feature/ui-refresh 514ed80
- claromentis/peoplecomponent@dev-feature/ui-refresh d42f699

## 9.0.0-alpha - 11th May 2021

Initial pre-release.

- Composer project that includes [Claromentis Core](https://gitlab.com/claromentis/product/core) & Modules
- Dockerfile for a Claromentis Docker image based on PHP-FPM & Nginx
- GitLab CI pipeline for static distribution and Docker image builds

### Versions

All modules are on development branches for Core 9.0 compatibility.

As development progresses, module branches will merge as follows:

- `feature/ui-refresh` -> `feature/9.0` -> `<New major.minor version branch>`

Version list:

- claromentis/anniversary@dev-feature/ui-refresh 8f952e3
- claromentis/announcements@dev-feature/ui-refresh 073905d
- claromentis/assets@dev-feature/ui-refresh 7dc7c2f
- claromentis/audit@dev-feature/ui-refresh 78449c5
- claromentis/badges@dev-feature/ui-refresh f061cca
- claromentis/buttons@dev-feature/ui-refresh 11fbceb
- claromentis/countdown@dev-feature/ui-refresh 2f96f61
- claromentis/discuss@dev-feature/ui-refresh 4152da1
- claromentis/dmsv@dev-feature/ui-refresh 12136da
- claromentis/events@dev-feature/ui-refresh 4b4c3aa
- claromentis/expenses@dev-feature/ui-refresh 6613487
- claromentis/framework@9.0.0-alpha
- claromentis/hr@dev-feature/ui-refresh 9d07e7b
- claromentis/icdashboard@dev-feature/ui-refresh f1e6049
- claromentis/installer-composer-plugin@v2.0.x-dev 3495878
- claromentis/knowledgebase@dev-feature/ui-refresh 11206db
- claromentis/learning@dev-feature/ui-refresh 2727dbe
- claromentis/lms@dev-feature/9.0 23bcd12
- claromentis/oembed@dev-feature/ui-refresh 37c69ab
- claromentis/pages@dev-feature/ui-refresh d7a52e3
- claromentis/peoplecomponent@dev-feature/ui-refresh ef36a53
- claromentis/policy@dev-feature/ui-refresh 21bcdbc
- claromentis/projects@dev-feature/ui-refresh b875fa3
- claromentis/quiz@dev-feature/ui-refresh 17c3525
- claromentis/reports@dev-feature/ui-refresh d9c72ec
- claromentis/rssreader@dev-feature/ui-refresh 78dc759
- claromentis/slider@dev-feature/ui-refresh 0fc8d4a
- claromentis/socialconnect@dev-feature/ui-refresh 031f4fc
- claromentis/stock@dev-feature/ui-refresh 53c7d6a
- claromentis/task@2.1.12
- claromentis/thankyou@dev-feature/ui-refresh 41839af
- claromentis/twofactor@dev-feature/ui-refresh 525b8a3
- claromentis/weather@dev-feature/ui-refresh aa50b2f
- claromentis/worldclock@dev-feature/ui-refresh 80e1a29