# Claromentis 9.0 Upgrade Guide

Claromentis 9.0.0 is the first new major version of the product since 2016. Despite this, the development team have
tried to keep backwards-incompatible changes to a minimum and keep the upgrade process as simple as possible.

This guide provides the process for manually upgrading a Claromentis 8.13 system to Claromentis 9.<br/>
It is written for **Support Technicians** that perform manual Claromentis upgrades on client systems.

## Assumptions

This guide currently makes the following assumptions, for the sake of simplifying examples, that
**you may have to adapt** for the system that you're upgrading:

- Claromentis 8.x is installed on a Linux system at `/Claromentis/application`
- Correct ownership for all files is `apache:claroteam`
- The web server uses `/Claromentis/application/web` as the document root, and `/Claromentis/application/web/index.php`
  as front-controller fallback for requested paths that are not found
- The **user** you are running as has **full permissions** to read, write and delete everything in the `/Claromentis`
    - Your user's primary group should be `claroteam`, or whichever group shares read-write permissions with Apache/PHP
    - You **will encounter permission errors** if you run the below verbatim without setting permissions properly

## Preparation

1. **Disable user access** to the Claromentis system
    - This can be using Apache redirects, or any other means
    - The main purpose is to prevent users from changing any system state during the upgrade, which could cause fatal
      errors during migrations
2. **Upgrade** to the **latest Claromentis Core 8.13.x** release, uninstalling `chat` and `social`
    1. Remove `claromentis/chat` and `claromentis/social` from `/Claromentis/application/modules.json`
    2. Run `composer update -d installer --prefer-dist --no-dev` from `/Claromentis/application`
        - Provide `yes` to the prompts if you are asked to delete the database schema for `chat` or `social`
3. Create a **full backup** of the application, data volume, and database
    - Application: `/Claromentis/application`
    - Data volume: `/Claromentis/data`
    - Database: MySQL or SQL Server dump of the `claromentis` database
4. Ensure a **stateless application directory**
    1. **Extract configuration** from `/Claromentis/application/web/intranet/common/config.php`
        - Environment configuration belongs in `/Claromentis/.env` or real environment variables
        - Product configuration and preferences belong in `/Claromentis/data/config/core.json` by using the
          [Configuration Editor](https://docs.claromentis.net/#/product/core/docs/technical/configuration/?id=configuration-editor)
          at **Admin > System > Configuration > Core**
        - See [Configuration](https://docs.claromentis.net/#/product/core/docs/technical/configuration/) for more
          information
    2. Ensure that the **data volume** is situated at `/Claromentis/data`, and **not inside the Core application**
       directory of `/Claromentis/application/data`
        - If you need to move the data volume from `/Claromentis/application/data` to `/Claromentis/data`, make sure you
          also set the `CLARO_DATA_DIR` environment variable to `/Claromentis/data` afterwards
        - `/Claromentis/data` is usually the default data volume path, so you will likely be able to skip this step
5. Ensure that **filesystem permissions** are correct
    1. Set ownership: `sudo chown -R apache:claroteam /Claromentis`
    2. Set permissions: `sudo chmod -R ug+rwX,o+r,o-wx /Claromentis`
6. **(Optional)** Upgrade from Composer 1 to Composer 2
    - `sudo composer self-update --2` to upgrade an existing Composer binary
    - https://getcomposer.org/download/ to install a new Composer binary
    - This is optional because the new process remains compatible with Composer 1, but it is **highly recommended** to
      update Composer for improved performance, stability, and compatibility

## Upgrading

The installation and upgrade process has changed in Claromentis 9. This includes running `composer install` from
`/Claromentis` instead of running `composer update` from `/Claromentis/application/installer`.

See [Motivation](#motivation) for a summary of the changes to the process and the motivations behind them.

> **Note:**<br/>
> This new installation process is **backwards-compatible with Claromentis 8.12+**.</br>
> If you would like to use this approach for Claromentis 8 installations and upgrades, please do try it out.</br>

> **Note:**<br/>
> This guide does not yet support Claromentis installations with **custom modules**. This includes Codedev.<br/>
> Adapting this new process for customised installations is a work in progress.

1. **Find the `composer.json` and `composer.lock` files** for the Claromentis release you want to install
    1. Visit https://packages.claromentis.net/#claromentis/claromentis
    2. Download the release package for the version you want to install<br/>
       e.g. https://storage.googleapis.com/satisfactory/packages/claromentis/claromentis/claromentis-claromentis-9.0.0-rc3-e19f9faa.zip
    3. Extract `composer.json` and `composer.lock` from the archive
2. **Copy `composer.json` and `composer.lock`** to `/Claromentis/composer.json` and `/Claromentis/composer.lock` on the
   server
3. **Install the codebase**
    - Run `composer install --prefer-dist --no-dev --optimize-autoloader` from `/Claromentis` as an appropriate user
4. **Run migration scripts:**
    - Run `./clc app:upgrade --all` from `/Claromentis/application`
5. **Restore user access** to the Claromentis system

If you encounter any errors, please report them to the Core development team.

## Motivation

There were several problems with the installation process for Claromentis 8.

- **Non-deterministic installations**
    - Depending on when you run the `composer update` command, you may end up with different versions of Core & Modules
      based on what has been released
    - This results in a fragmentation of Claromentis Core & Module versions across client systems, increasing the
      likelihood of bugs that are difficult to reproduce on other systems
- **Dirty upgrades**
    - The Claromentis 8 upgrade process copies new versions of Claromentis Core _on top of the existing installation_
        - This leads to old files not being deleted properly if they are missed by cleanup migrations, and can cause
          bugs
        - The main reason for this was to retain **stateful file paths**, such as `config.php` and `web/appdata`, which
          were mixed into the file structure of the **application codebase**
    - `modules.json` is maintained on client servers only, and not anywhere else, meaning we have to connect to client
      servers to determine what's installed
    - Custom modules are installed separately to Core & Modules, creating the potential for conflicting dependencies and
      contributing to further variance across deployments that we have to track (or rediscover) manually
- **Dependency bundling**
    - Claromentis Core distributions abuse Composer's behaviour by bundling fixed dependencies, which complicates our
      [build system](https://gitlab.com/claromentis/product/services/satisfactory) and our
      [Composer Installer Plugin](https://gitlab.com/claromentis/product/composer-installer)
    - Core dependencies and modules are installed differently between development and production system across two
      separate directories (`vendor` and `vendor_core`), resulting in some bugs that are difficult to reproduce, and
      difficulty installing module dependencies on development systems
- **Performance**
    - Composer 1 consumes a lot of memory, and downloads and installs each package one-by-one
    - Additionally, Composer 1 was officially deprecated in 2021

The installation process for Claromentis 9 has been improved considerably. It is simpler, faster, and more predictable.

- `/Claromentis/application/installer` has been removed and the
  [Claromentis project](https://gitlab.com/claromentis/product/claromentis) has been introduced
    - Powered by **[Composer Installer Plugin 2.0.0](https://gitlab.com/claromentis/product/composer-installer)** and
      Composer 2
    - Supports **Composer 2** for asynchronous downloads and installation, lower memory consumption
- Previously, we would run `composer update -d installer --prefer-dist --no-dev` from `/Claromentis/application`
    - This would merge `/Claromentis/application/installer/composer.json` and `/Claromentis/application/modules.json`
      and result in non-deterministic, dirty upgrades
    - Installs over itself in `/Claromentis/application`
- Moving forward, we will run `composer install --prefer-dist --no-dev` from `/Claromentis`
    - This uses a new `/Claromentis/composer.lock` that specifies _**exact**_ dependencies for deterministic
      installations
    - Installs into `/Claromentis/application` as a subdirectory
    - Retains known stateful file paths if there are any, performs faster when there aren't any
    - If there are no stateful files in `/Claromentis/application`, it's safe to `rm -rf /Claromentis/application` and
      reinstall the codebase with `composer install`
    - Installations that use custom modules will require their own `composer.json` and `composer.lock` files, meaning
      that we control system variation from a Git repository rather than a single file on a server
