# Claromentis CI/CD

Claromentis uses [GitLab CI/CD](https://docs.gitlab.com/ee/ci/) to facilitate
continuous integration and continuous delivery: [CI/CD](https://en.wikipedia.org/wiki/CI/CD).
This GitLab feature offers us a powerful means to automate the delivery and
deployment of our software.

## Overview

Software projects will define and use different [CI/CD pipelines](https://docs.gitlab.com/ee/ci/pipelines/)
depending on their needs, and pipelines are defined by a
[`.gitlab-ci.yml` configuration file](https://docs.gitlab.com/ee/ci/yaml/README.html).
These files describe pipeline **stages** that each contain a number of **jobs**,
which can run automatically under different circumstances. For example,
automated test jobs can run for every Git commit push, or a release job can run
for every Git tag push.

CI/CD pipelines are commonly used to:

- Lint the codebase to ensure a consistent code style
- Run unit tests, end-to-end tests, or other automated tests
- Build software as packaged distribution archives or as Docker images
- Publish software releases
- Deploy software to a server infrastructure

<!--
    TODO: List notable/critical CI/CD pipelines for the Claromentis ecosystem
          e.g. Core, Satisfactory, Documentis, developer.claromentis.com, etc
-->

## Claromentis CI/CD pipeline

![Directed acyclic graph of a successful Claromentis CI/CD pipeline](./images/cicd-dag.png)

The [Claromentis project](https://gitlab.com/claromentis/product/claromentis)
defines a CI/CD pipeline that performs the following jobs for every commit push
or tag push to the project's Git repository.

1. **Setup stage**
    1. `setup:composer`: Install project dependencies using [Composer](https://getcomposer.org/)
    2. `setup:variables`: Dynamically define derived CI/CD variables for later
        pipeline stages
2. **Build stage**
    1. `build:docker`: Build a production Claromentis Docker image
    2. `build:docker-dev`: Build a development Claromentis Docker image
3. **Test stage**
    1. `test:health`: Run health checks against a Claromentis instance
    2. `test:install`: Test the production Claromentis installation process
    3. `test:install-dev`: Test the development Claromentis installation process
    4. `test:phpcs`: Use [PHPCS](https://github.com/squizlabs/PHP_CodeSniffer)
        to scan for any incompatibilities or usage of deprecated PHP features
    6. `test:phpunit`: Run [PHPUnit](https://phpunit.de/) automated test suites
4. **Release stage**
    1. **[Tag push]** `release:package`: Build and upload a Claromentis
       distribution to the [GitLab Generic Packages Registry](https://docs.gitlab.com/ee/user/packages/generic_packages/)
    2. **[Tag push]** `release:gitlab`: Create a [GitLab release](https://docs.gitlab.com/ee/user/project/releases/)
       and associate its corresponding packages
    3. `release:docker`: Tag and push the production Docker image to the
       [GitLab Container Registry](https://docs.gitlab.com/ee/user/packages/container_registry/)
       and [Google Container Registry](https://cloud.google.com/container-registry)
    4. `release:docker-dev`: Tag and push the development Docker image to GitLab
       Container Registry
5. **Deploy stage**
    - Placeholder stage for extending projects, such as
      [Distros](https://gitlab.com/claromentis/product/distros), to deploy
      Claromentis instances

### Variable reference

The Claromentis CI/CD pipeline uses a several [CI variables](https://docs.gitlab.com/ee/ci/variables/)
to maintain consistent information throughout its lifecycle. Below is a
reference for those variables.

- **[Configurable]** variables can be configured by the GitLab project's CI/CD
  settings:
  <br/>See **Settings > CI/CD > Variables** as a project maintainer
- **[Derived]** variables are variables that have been defined dynamically at
  runtime by a CI/CD job
  <br/>All other variables have static values that are defined by
  [predefined GitLab CI variables](https://docs.gitlab.com/ee/ci/variables/predefined_variables.html)

| CI/CD variable name       | Example values                                                                                                                 | Description                                                                            |
|---------------------------|--------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------|
| `CACHE_FALLBACK_KEY`      | `9-0`                                                                                                                          | Fallback key for caching Composer dependencies                                         |
| `CI_PACKAGE_VERSION`      | `9.0.0`                                                                                                                        | Version name to use for the GitLab Generic Package release                             |
| `CI_PACKAGE_FILE`         | `claromentis-9.0.0`                                                                                                            | File name to use for publishing a GitLab Generic Package, excluding the file extension |
| `CI_PACKAGE_FILE_ZIP`     | `claromentis-9.0.0.zip`                                                                                                        | File name to use for publishing a GitLab Generic Package, including the file extension |
| `CI_PACKAGE_REGISTRY_URL` |                                                                                                                                | GitLab API URL to use for publishing a GitLab Generic Package                          |
| `CI_PHP_IMAGE`            | <details><summary>Expand/collapse</summary>`registry.gitlab.com/claromentis/infrastructure/docker/php:7.4-alpine-ci`</details> | PHP Docker image name to use for PHP CI/CD jobs                                        |
| `CI_DOCKER_BASE_IMAGE`    | <details><summary>Expand/collapse</summary>`registry.gitlab.com/claromentis/infrastructure/docker/php`</details>               | Base Docker image name to use for Docker image builds                                  |
| `CI_DOCKER_BASE_TAG`      | `7.4-fpm-alpine`                                                                                                               | Base Docker image tag to use for production Docker image builds                        |
| `CI_DOCKER_BASE_TAG_DEV`  | `7.4-fpm-alpine-dev`                                                                                                           | Base Docker image tag to use for development Docker image builds                       |
| `CI_DOCKER_BUILD_TAG`     | `build-123`                                                                                                                    | Docker image tag to use for intermediate production Docker images                      |
| `CI_DOCKER_BUILD_TAG_DEV` | `build-123-dev`                                                                                                                | Docker image tag to use for intermediate development Docker images                     |
| `CI_DOCKER_DEFAULT_TAG`   | `latest`                                                                                                                       | Docker image tag to use as a fallback for build caching                                |
| `CI_DOCKER_TAG`           | `9.0.0`, `9.0-edge`                                                                                                            | **[Derived]** Docker image tag to use for production Docker images                     |
| `CI_DOCKER_TAG_DEV`       | `9.0.0-dev`                                                                                                                    | **[Derived]** Docker image tag to use for development Docker images                    |
| `CI_DOCKER_TAG_MAJOR`     | `9`                                                                                                                            | **[Derived]** Docker image tag to use for major versions of production Docker images   |
| `CI_DOCKER_TAG_MINOR`     | `9.0`                                                                                                                          | **[Derived]** Docker image tag to use for minor versions of production Docker images   |
| `CI_DOCKER_TAG_MAJOR_DEV` | `9-dev`                                                                                                                        | **[Derived]** Docker image tag to use for major versions of development Docker images  |
| `CI_DOCKER_TAG_MINOR_DEV` | `9.0-dev`                                                                                                                      | **[Derived]** Docker image tag to use for minor versions of development Docker images  |
| `CI_GITLAB_IMAGE`         | <details><summary>Expand/collapse</summary>`registry.gitlab.com/claromentis/product/claromentis`</details>                     | GitLab Container Registry URL to push Docker images to                                 |
| `CI_GCR_IMAGE`            |                                                                                                                                | Google Container Registry URL to push Docker images to                                 |
| `GCR_PROJECT`             | `claro-registry-dev`                                                                                                           | **[Configurable]** Google Container Registry project name                              |
| `GCR_REGION`              | `us`                                                                                                                           | **[Configurable]** Google Container Registry region                                    |
| `GCR_SA`                  |                                                                                                                                | **[Configurable]** JSON service account credentials for Google Container Registry      |
