# Installation requirements

This document is a reference for the hardware and software requirements needed to install Claromentis.

## Summary

Platform requirements summary.

| Claromentis | PHP       | Web server                            | Database                             | Elasticsearch |
|-------------|-----------|---------------------------------------|--------------------------------------|---------------|
| 9.0         | 7.4 x64   | Apache 2.4<br/>Nginx 1.18+<br/>IIS 10 | MySQL 5.7<br/>SQL Server 2019+       | 7             |
| 8.11 - 8.13 | 7.4       | Apache 2.4<br/>Nginx 1.18+<br/>IIS 10 | MySQL 5.7<br/>SQL Server 2016+       | 7 / 1         |
| 8.9 - 8.10  | 7.1 - 7.2 | Apache 2.4<br/>Nginx 1.17+<br/>IIS 10 | MySQL 5.7<br/>SQL Server 2016+       | 7 / 1         |
| 8.7 - 8.8   | 7.1 - 7.2 | Apache 2.4<br/>Nginx 1.17+<br/>IIS 10 | MySQL 5.7<br/>SQL Server 2016+       | 1             |
| 8.6         | 7.0 - 7.1 | Apache 2.4<br/>Nginx 1.15+<br/>IIS 10 | MySQL 5.7<br/>SQL Server 2016+       | 1             |
| 8.3 - 8.5   | 7.0       | Apache 2.4<br/>IIS 10                 | MySQL 5.7<br/>SQL Server 2016+       | 1             |
| 8.2         | 5.6 - 7.0 | Apache 2.4<br/>IIS 10                 | MySQL 5.7<br/>SQL Server 2016+       | 1             |
| 8.0 - 8.1   | 5.6       | Apache 2.4<br/>IIS 8.5                | MySQL 5.7<br/>SQL Server 2014+       | 1             |
| 7.4         | 5.4 - 5.6 | Apache 2.2 - 2.4<br/>IIS 8.5          | MySQL 5.6 - 5.7<br/>SQL Server 2012+ | 1             |

## Operating Systems

- Alpine Linux (3.13, 3.14, 3.15)
- Debian (9, 10, 11)
- CentOS (8)
- Ubuntu (18.04, 20.04)
- Windows Server 2019+
- Windows 10+

## Software requirements

### Databases

- MariaDB 10.2+
- MySQL 5.7
- SQL Server 2019+
- SQLite 3

### PHP

- https://php.net/supported-versions.php
- https://discover.claromentis.com/knowledgebase/articles/307/en

| Claromentis | PHP 5.4 | 5.5 | 5.6 | 7.0 | 7.1 | 7.2 | 7.4 | 8.0 | 8.1 |
|-------------|---------|-----|-----|-----|-----|-----|-----|-----|-----|
| 9.0         |         |     |     |     |     |     | ✔   |     |     |
| 8.13        |         |     |     |     |     |     | ✔   |     |     |
| 8.12        |         |     |     |     |     |     | ✔   |     |     |
| 8.11        |         |     |     |     |     |     | ✔   |     |     |
| 8.10        |         |     |     |     | ✔   | ✔   |     |     |     |
| 8.9         |         |     |     |     | ✔   | ✔   |     |     |     |
| 8.7         |         |     |     |     | ✔   | ✔   |     |     |     |
| 8.6         |         |     |     | ✔   | ✔   |     |     |     |     |
| 8.5         |         |     |     | ✔   |     |     |     |     |     |
| 8.4         |         |     |     | ✔   |     |     |     |     |     |
| 8.3         |         |     |     | ✔   |     |     |     |     |     |
| 8.2         |         |     | ✔   | ✔   |     |     |     |     |     |
| 8.1         |         |     | ✔   |     |     |     |     |     |     |
| 8.0         |         |     | ✔   |     |     |     |     |     |     |
| 7.4         | ✔       | ✔   |     |     |     |     |     |     |     |

> **Note:**<br/>
> 64-bit builds of PHP are now **required** for Claromentis 9 and above, and
> **highly encouraged** for Claromentis 8.<br/>
> 32-bit builds of PHP are **discouraged**.

#### Extensions

| Name                                                                          | Code        |
|-------------------------------------------------------------------------------|-------------|
| [Document Object Model](https://www.php.net/manual/en/book.dom.php)           | `dom`       |
| [Client URL Library](https://www.php.net/manual/en/book.curl.php)             | `curl`      |
| [File Information](https://www.php.net/manual/en/book.fileinfo.php)           | `fileinfo`  |
| [iconv](https://www.php.net/manual/en/book.iconv.php)                         | `iconv`     |
| [Internationalization functions](https://www.php.net/manual/en/book.intl.php) | `intl`      |
| [Image Processing and GD](https://www.php.net/manual/en/book.image.php)       | `gd`        |
| [JavaScript Object Notation](https://www.php.net/manual/en/book.json.php)     | `json`      |
| [XML Manipulation](https://www.php.net/manual/en/book.libxml.php)             | `libxml`    |
| [Multibyte String](https://www.php.net/manual/en/book.mbstring.php)           | `mbstring`  |
| [OpenSSL](https://www.php.net/manual/en/book.openssl.php)                     | `openssl`   |
| [SimpleXML](https://www.php.net/manual/en/book.simplexml.php)                 | `simplexml` |
| [XML Parser](https://www.php.net/manual/en/book.xml.php)                      | `xml`       |
| [Zip](https://www.php.net/manual/en/book.zip.php)                             | `zip`       |
| [Zlib Compression](https://www.php.net/manual/en/book.zlib.php)               | `zlib`      |

#### Optional extensions

| Name                                                                                         | Code        | Purpose                                                  |
|----------------------------------------------------------------------------------------------|-------------|----------------------------------------------------------|
| [Exchangeable image information](https://www.php.net/manual/en/book.exif.php)                | `exif`      | Required to parse EXIF metadata from image files         |
| [Lightweight Directory Access Protocol](https://www.php.net/manual/en/book.ldap.php)         | `ldap`      | Required for LDAP user directory integration             |
| [Memcache](https://www.php.net/manual/en/book.memcache.php)                                  | `memcache`  | Required for the Memcache cache driver                   |
| [Memcached](https://www.php.net/manual/en/book.memcached.php)                                | `memcached` | Required for the Memcached cache driver                  |
| MSSQL                                                                                        | `mssql`     | Required for the Sybase MSSQL database driver            |
| [MySQL Improved Extension](https://www.php.net/manual/en/book.mysqli.php)                    | `mysqli`    | Required for the MySQL database driver                   |
| [ODBC (Unified)](https://www.php.net/manual/en/book.uodbc.php)                               | `odbc`      | Required for the ODBC MSSQL database driver              |
| [OPcache](https://www.php.net/manual/en/book.opcache.php)                                    | `opcache`   | Required for PHP Opcode caching                          |
| [Microsoft SQL Server and Sybase Functions](https://www.php.net/manual/en/ref.pdo-dblib.php) | `pdo_dblib` | Required for MSSQL database access in Linux environments |
| [Rar Archiving](https://www.php.net/manual/en/book.rar.php)                                  | `rar`       | Required for RAR archive processing                      |
| [SOAP](https://www.php.net/manual/en/book.soap.php)                                          | `soap`      | Required for internet license activation                 |                                                          |
| [SQLite3](https://www.php.net/manual/en/book.sqlite3.php)                                    | `sqlite3`   | Required for the SQLite 3 database driver                |                                                          |
| [Microsoft SQL Server Driver for PHP](https://www.php.net/manual/en/book.sqlsrv.php)         | `sqlsrv`    | Required for the MSSQL Native Client database driver     |                                                          |

### Web Servers

| Web server | Version | Operating System |
|------------|---------|------------------|
| Apache     | 2.4+    | Linux or Windows |
| Nginx      | 1.18+   | Linux or Windows |
| IIS        | 10.0+   | Windows          |

### Elasticsearch

| Claromentis | Elasticsearch 1 | Elasticsearch 7 |
|-------------|-----------------|-----------------|
| 9.0+        |                 | ✔               |
| 8.9 - 8.13  | ✔               | ✔               |
| 7.4 - 8.8   | ✔               |                 |

### Binaries

| Claromentis | ImageMagick | wkhtmltopdf |
|-------------|-------------|-------------|
| 8.9 - 9.0   | 7.x         | 0.12.5+     |

## Hardware requirements

> **Coming soon**

## References

- [Apache Versions](https://en.wikipedia.org/wiki/Apache_HTTP_Server#Versions)
- [Internet Information Services (IIS) Release Lifecycle](https://docs.microsoft.com/en-us/lifecycle/products/internet-information-services-iis)
- [MariaDB vs. MySQL: Compatibility](https://mariadb.com/kb/en/mariadb-vs-mysql-compatibility/)
- [Microsoft Windows Server versions](https://en.wikipedia.org/wiki/List_of_Microsoft_Windows_versions#Server_versions)
- [Microsoft SQL Server Versions List](https://sqlserverbuilds.blogspot.com/)
- [MySQL Release History](https://en.wikipedia.org/wiki/MySQL#Release_history)
- [Nginx Release History](https://github.com/nginx/nginx/tags)