# Claromentis Installation Guide

This guide will take you through installing Claromentis.

> **WIP:** This documentation is a work in progress.

## Requirements

Please review the [installation requirements](-requirements.md) before
installing Claromentis.

## Methods

Choose the installation method that suits your platform and environment.

| Installation method                   | Description                                                  | Environment                                                                                                                                                       |
|---------------------------------------|--------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [**Docker Containers**](docker.md)    | Install Claromentis [Docker](https://docker.com) containers. | **Production:** Modern installation method. Recommended method for QA, Staging or Production deployments.                                                         |
| [**Distributions**](distributions.md) | Install Claromentis distributions using Composer.            | **Production:** Classic installation method. Use this method for installing into pre-existing web server environments, or environments that don't support Docker. |
| **Docker Compose**                    | Install Claromentis using a Docker Compose project.          | **Development:** Use this method for contributing to Claromentis software development.                                                                            |
| [**Source**](source.md)               | Install Claromentis source code using Composer & Git.        | **Development:** Use this method for contributing to Claromentis software development. Recommended alongside **Docker Compose** for environmental consistency.    |

> **Coming soon:** Detailed installation guides for each installation method.
 
<!-- TODO: Developer quick-start with Docker and Git. `docker-compose up -d`, then inside containers: `composer install`. -->