# Installation from distributions

Production deployments of Claromentis have traditionally been installed and updated manually using Composer to install
software distributions.

This guide explains how to install Claromentis from distribution archives using Composer.

- [Getting started](#getting-started)
- [Install the codebase](#install-the-codebase)
- [Create the database](#create-the-database)
- [Configure the environment](#configure-the-environment)
- [Install the database schema](#install-the-database-schema)
- [Configure the web server](#configure-the-web-server)
- [Install and configure services](#install-and-configure-services)

## Getting started

Please review the [installation requirements](-requirements.md) before installing Claromentis.

1. Install [Apache](https://httpd.apache.org/), [Nginx](https://www.nginx.com/), or [IIS](https://www.iis.net/)
2. Install [PHP](https://www.php.net/manual/en/install.php)
3. Install [Composer](https://getcomposer.org/download/)
4. Choose the **root directory** for the Claromentis installation
    - This is typically `/Claromentis` for Linux and `C:\Claromentis` for Windows
    - `<root>` will be used as a placeholder for the purposes of this guide

## Install the codebase

1. Find the `composer.json` and `composer.lock` files for the Claromentis release you want to install
    1. Visit https://packages.claromentis.net/#claromentis/claromentis
    2. Download the release package for the version you want to install<br/>
       e.g. https://storage.googleapis.com/satisfactory/packages/claromentis/claromentis/claromentis-claromentis-9.0.0-beta-9519debf.zip
    3. Extract `composer.json` and `composer.lock` from the archive
2. Copy the `composer.json` and `composer.lock` files to `<root>/composer.json` and `<root>/composer.lock` on the server
3. Run `composer install --prefer-dist --no-dev --optimize-autoloader` from `<root>` as an appropriate user

Review the installation directory:

- Claromentis Core will be installed into `<root>/application`
- Claromentis Modules will be installed into `<root>/application/web/intranet/<module>`
- Custom Modules will be installed into `<root>/application/web/custom/<module>`

<!-- Everything below this line should be kept in sync with source.md -->

## Create the database

Claromentis installations work well when an empty database is initialized in advance.

1. Connect to the MySQL or SQL Server instance
2. Create a `claromentis` database
    - MySQL: Use the `utf8mb4` character encoding and `utf8mb4_unicode_ci` collation
    - SQL Server: Use the `UTF-8` character encoding
4. Create a `claromentis` user with:
    - Full permissions granted for the `claromentis` database
    - A secure password

## Configure the environment

Environment variables are used to configure Claromentis' awareness of external systems.

See [Core Configuration](https://docs.claromentis.net/#/product/core/docs/technical/configuration/README?id=environment)
for the full reference of available environment variables.

1. Create a `.env` file in the **root directory** of the Claromentis installation
2. Write the following the variables to the `.env` file, replacing `<root>`, `<hostname>` and `<password>` with the
   appropriate values:
   ```env
   CLARO_DATA_DIR="<root>/data"
   CLARO_LOCAL_DATA_DIR="<root>/local_data"
   CLARO_DB_TYPE="mysql"
   CLARO_DB_HOST="<hostname>"
   CLARO_DB_NAME="claromentis"
   CLARO_DB_USER="claromentis"
   CLARO_DB_PASS="<password>"
   ```

!> **Note:**<br/>This guide describes how to use a `.env` file to configure environment variables for development systems. For production systems, it is
**highly recommended** to use real environment variables instead.

## Install the database schema

Now that the database exists and Claromentis is able to find it, we can install the Claromentis database schema.

1. Navigate to the `application` directory in the **root directory** of the installation
2. Run `./clc app:install --all --admin_password=<password> --no-interaction`

## Configure the web server

Claromentis can be served by Apache, Nginx and IIS web servers. Each needs to be configured differently in order to
serve Claromentis requests correctly.

HTTP requests should be handled like so:

1. If the requested file path **exists** at `<root>/application/web/<path>`:
   - If `<path>` is a static resource, serve it (e.g. `.css`, `.js`, `.jpg`, `.png`, `.html`, etc)
   - If `<path>` is a directory, serve the `index.php` or `index.html` within if it exists
   - If `<path>` is a PHP script, process it and serve the response (`.php`)
2. If the requested file path **does not exist** at `<root>/application/web/<path>`:
   - Forward the request to the Claromentis front controller: `<root>/application/web/index.php`
3. Set the following CGI variables before processing any PHP scripts:
   - `SERVER_NAME`: Canonical hostname
   - `SCRIPT_FILENAME`: Absolute file path of `<root>/application/web/index.php` or requested path
   - `PATH_INFO`: Requested URL path
   - `PATH_INFO_TRANSLATED`: `<SCRIPT_FILENAME><PATH_INFO>` concatenation

Below are example web server configurations that implement this request handling behaviour.

!> **Note:**<br/>This guide does not cover SSL configuration for serving Claromentis over HTTPS.

<!-- tabs:start -->

### **Apache**

Configure Apache to:

1. Allow serving files from the Claromentis `web` directory
   - `AllowOverride All` allows `.htaccess` files in the Claromentis codebase to control routing behaviour
2. Serves files from the Claromentis `web` directory for a specific hostname

Adapt the following into your `conf/httpd.conf` or `conf/httpd-vhosts.conf` Apache configuration file.

```apacheconf
<Directory "C:\Claromentis\application\web\*">
	Options All
	AllowOverride All
	Require all granted
</Directory>

<VirtualHost *:80>
    ServerAlias example.com
    VirtualDocumentRoot "C:\Claromentis\application\web"
    ErrorLog "logs/example-error.log"
    CustomLog "logs/example-access.log"
</VirtualHost>
```

### **Nginx**

Below is an annotated example Nginx server configuration from our Docker images.

1. Serve static files, falling back to the Claromentis front controller
2. Serve PHP scripts (`*.php` request URIs) using PHP-FPM via FastCGI, falling back to the Claromentis front controller
3. Serve requests using the Claromentis front controller using PHP-FPM via FastCGI

```nginx configuration
# Define the Claromentis virtual host
server {
    set $php_fpm 127.0.0.1;

    listen 80 default_server;
    server_name 127.0.0.1;

    # Document root
    root /var/www/claromentis/application/web;

    # Disable directory indexing
    autoindex off;

    # Index pages
    index index.html index.php;

    # Maximum request body size
    client_max_body_size 128M;

    # Serve static files, fall back to PHP-FPM
    location / {
        try_files $uri $uri/index.html @php-fpm;
    }

    # Serve *.php requests using PHP-FPM
    location ~ [^/]\.php(/|$) {
        # Fall back to the front controller if the script doesn't exist
        fastcgi_split_path_info ^(.+?\.php)(/.*)$;
        try_files $fastcgi_script_name @php-fpm;

        # Bypass the fact that try_files rewrites the Request URI
        # and, as a result, the value of $fastcgi_path_info
        # https://stackoverflow.com/a/67252133/1744006
        # https://trac.nginx.org/nginx/ticket/321
        set $path_info $fastcgi_path_info;

        fastcgi_pass $php_fpm:9000;
        fastcgi_index index.php;
        include fastcgi_params;
        fastcgi_param SERVER_NAME $host;
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
        fastcgi_param PATH_INFO $path_info;
        fastcgi_param PATH_TRANSLATED $document_root$path_info;

        # https://httpoxy.org/
        fastcgi_param HTTP_PROXY "";
    }

    # Virtual location for handling PHP-FPM front controller requests
    location @php-fpm {
        fastcgi_pass $php_fpm:9000;
        include fastcgi_params;
        fastcgi_param SERVER_NAME $host;
        fastcgi_param SCRIPT_FILENAME $document_root/index.php;

        # https://httpoxy.org/
        fastcgi_param HTTP_PROXY "";
    }

    # Omit favicon logs
    location = /favicon.ico {
        access_log off;
        log_not_found off;
    }
}
```

### **IIS**

Claromentis includes a `web.config` file in its document root directory (`application/web`) that configures IIS
automatically, but below is the expected configuration in case this feature is disabled in your environment.

1. Create an IIS Site for Claromentis
2. Configure the IIS Site to serve files from `<root>/application/web`<br/>
   ![IIS Virtual Directory configuration](iis-1.png)
3. Configure the IIS Site's URL rewrite:<br/>
   ![IIS URL Rewrite configuration](iis-2.png)
   1. Add trailing slashes for matching directories
   2. Serve the Claromentis front controller for non-matching file paths

<!-- tabs:end -->

## Install and configure services

See the [Installing and configuring services](services.md) guide to learn how to install and configure the external
services that Claromentis can utilise.